/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.fiber4j;

import com.github.akurilov.commons.collection.CircularArrayBuffer;
import com.github.akurilov.commons.collection.CircularBuffer;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.fiber4j.ExclusiveFiberBase;
import com.github.akurilov.fiber4j.Fiber;
import com.github.akurilov.fiber4j.FibersExecutor;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransferFiber<T>
extends ExclusiveFiberBase
implements Fiber {
    private static final Logger LOG = Logger.getLogger(TransferFiber.class.getName());
    private final Input<T> input;
    private final Output<T> output;
    private final CircularBuffer<T> itemsBuff;
    private final int capacity;
    private int n;

    public TransferFiber(FibersExecutor executor, Input<T> input, Output<T> output, int capacity) {
        this(executor, new CircularArrayBuffer(capacity), input, output);
    }

    public TransferFiber(FibersExecutor executor, CircularBuffer<T> itemsBuff, Input<T> input, Output<T> output) {
        super(executor);
        this.input = input;
        this.output = output;
        this.itemsBuff = itemsBuff;
        this.capacity = itemsBuff.capacity();
    }

    @Override
    protected final void invokeTimedExclusively(long startTimeNanos) {
        try {
            if (this.isStarted()) {
                this.input.get(this.itemsBuff, this.capacity - this.itemsBuff.size());
            }
            this.n = this.itemsBuff.size();
            if (this.n > 0) {
                if (1 == this.n) {
                    T item = this.itemsBuff.get(0);
                    if (this.output.put(item)) {
                        this.itemsBuff.clear();
                    }
                } else {
                    this.n = this.output.put(this.itemsBuff, 0, Math.min(this.n, this.capacity));
                    this.itemsBuff.removeFirst(this.n);
                }
            }
        }
        catch (ConnectException | NoSuchObjectException item) {
        }
        catch (EOFException e) {
            try {
                this.close();
            }
            catch (IOException ee) {
                LOG.log(Level.WARNING, "Failed to close self after EOF", ee);
            }
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EOFException) {
                try {
                    this.close();
                }
                catch (IOException ee) {
                    LOG.log(Level.WARNING, "Failed to close self after EOF", ee);
                }
            } else {
                LOG.log(Level.WARNING, "Failure", e);
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failure", e);
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit timeUnit) throws IllegalStateException, InterruptedException {
        if (this.isShutdown()) {
            long invokeTimeMillis = System.currentTimeMillis();
            long timeOutMillis = timeUnit.toMillis(timeout);
            while (timeOutMillis > System.currentTimeMillis() - invokeTimeMillis) {
                if (this.itemsBuff.isEmpty()) {
                    return true;
                }
                LockSupport.parkNanos(1L);
            }
            return false;
        }
        return super.await(timeout, timeUnit);
    }

    @Override
    protected void doClose() throws IOException {
        this.itemsBuff.clear();
    }
}

