var multiUserConfig = {
	"item" : {
		"data" : {
			"size" : "10KB"
		},
		"output" : {
			"file" : "objects.csv",
			/*
			Note the seed value "314159265" used to init the internal PRNG.
			This is a dirty hack. The same seed value should be used as a part of uid dynamic
			value to get the same "XY" value for each pair of "bucket-XY" and "user-XY" supplied
			*/
			"path" : "bucket-%d(314159265){00}[0-99]"
		}
	},
	"load" : {
		"op" : {
			"limit" : {
				"count" : 10000
			}
		}
	},
	"storage" : {
		"auth" : {
			/*
			The file "credentials.csv" should be prepared manually. Contents:
			user-00,secret-00
			user-01,secret-01
			user-02,secret-02
			...
			user-99,secret-99
			To make this example file you may use the following 2 commands:
			for i in $(seq 0 9); do echo "user-0$i,secret-0$i" >> credentials.csv; done
			for i in $(seq 10 99); do echo "user-$i,secret-$i" >> credentials.csv; done
			*/
			"file" : "credentials.csv",
			"uid" : "user-%d(314159265){00}[0-99]"
		},
		"driver" : {
			"limit" : {
				"concurrency" : 10
			}
			"type" : "s3"
		}
	}
};

Load
	.config(multiUserConfig)
	.run();
