/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.config;

import com.emc.mongoose.base.config.IllegalArgumentNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;

public interface CliArgUtil {
    public static final String ARG_PREFIX = "--";
    public static final String ARG_PATH_SEP = "-";
    public static final String ARG_VAL_SEP = "=";

    public static Map<String, String> parseArgs(String ... args) {
        Collector<String[], Map, Map> eloquentCollector = Collector.of(HashMap::new, (map, argValPair) -> map.put(argValPair[0], argValPair[1]), (m1, m2) -> {
            m2.forEach(m1::put);
            return m1;
        }, new Collector.Characteristics[0]);
        return Arrays.stream(args).peek(CliArgUtil::checkArgPrefix).map(arg -> arg.substring(ARG_PREFIX.length())).map(arg -> arg.split(ARG_VAL_SEP, 2)).map(CliArgUtil::handleBooleanShortcuts).collect(eloquentCollector);
    }

    private static void checkArgPrefix(String arg) {
        if (!arg.startsWith(ARG_PREFIX)) {
            throw new IllegalArgumentNameException(arg);
        }
    }

    private static String[] handleBooleanShortcuts(String[] argValPair) {
        String[] stringArray;
        if (argValPair.length == 2) {
            stringArray = argValPair;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = argValPair[0];
            stringArray = stringArray2;
            stringArray2[1] = Boolean.TRUE.toString();
        }
        return stringArray;
    }

    private static <K, V> void putUnique(Map<K, V> map, K key, V v1) {
        V v2 = map.putIfAbsent(key, v1);
        if (v2 != null) {
            throw new IllegalStateException(String.format("Duplicate key '%s' (attempted merging incoming value '%s' with existing '%s')", key, v1, v2));
        }
    }

    public static List<String> allCliArgs(Map<String, Object> schema, String sep) {
        ArrayList<String> allArgs = new ArrayList<String>();
        schema.entrySet().stream().map(schemaEntry -> CliArgUtil.argsFromSchemaEntry(ARG_PREFIX, sep, schemaEntry)).forEach(allArgs::addAll);
        return allArgs;
    }

    public static List<String> argsFromSchemaEntry(String prefix, String sep, Map.Entry<String, Object> schemaEntry) {
        ArrayList<String> args = new ArrayList<String>();
        String schemaKey = schemaEntry.getKey();
        Object schemaVal = schemaEntry.getValue();
        if (schemaVal instanceof Map) {
            ((Map)schemaVal).entrySet().stream().map(e -> CliArgUtil.argsFromSchemaEntry(prefix + schemaKey + sep, sep, e)).forEach(args::addAll);
        } else {
            args.add(prefix + schemaKey + "=<" + schemaVal + ">");
        }
        return args;
    }
}

