/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.config.el;

import com.emc.mongoose.base.config.el.CompositeExpressionInputBuilderImpl;
import com.emc.mongoose.base.config.el.RandomPath;
import com.emc.mongoose.base.env.DateUtil;
import com.github.akurilov.commons.io.el.ExpressionInput;
import com.github.akurilov.commons.math.MathUtil;
import com.github.akurilov.commons.math.Random;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public interface Language {
    public static final String FUNC_NAME_SEPARATOR = ":";
    public static final Map<String, Method> FUNCTIONS = new HashMap<String, Method>(){
        {
            try {
                this.put("date:formatNowIso8601", DateUtil.class.getMethod("formatNowIso8601", new Class[0]));
                this.put("date:formatNowRfc1123", DateUtil.class.getMethod("formatNowRfc1123", new Class[0]));
                this.put("date:format", DateUtil.class.getMethod("dateFormat", String.class));
                this.put("date:from", DateUtil.class.getMethod("date", Long.TYPE));
                this.put("env:get", System.class.getMethod("getenv", String.class));
                this.put("int64:toString", Long.class.getMethod("toString", Long.TYPE, Integer.TYPE));
                this.put("int64:toUnsignedString", Long.class.getMethod("toUnsignedString", Long.TYPE, Integer.TYPE));
                this.put("int64:reverse", Long.class.getMethod("reverse", Long.TYPE));
                this.put("int64:reverseBytes", Long.class.getMethod("reverseBytes", Long.TYPE));
                this.put("int64:rotateLeft", Long.class.getMethod("rotateLeft", Long.TYPE, Integer.TYPE));
                this.put("int64:rotateRight", Long.class.getMethod("rotateRight", Long.TYPE, Integer.TYPE));
                this.put("int64:xor", Language.class.getMethod("xor", Long.TYPE, Long.TYPE));
                this.put("int64:xorShift", MathUtil.class.getMethod("xorShift", Long.TYPE));
                this.put("math:absInt32", Math.class.getMethod("abs", Integer.TYPE));
                this.put("math:absInt64", Math.class.getMethod("abs", Long.TYPE));
                this.put("math:absFloat32", Math.class.getMethod("abs", Float.TYPE));
                this.put("math:absFloat64", Math.class.getMethod("abs", Double.TYPE));
                this.put("math:acos", Math.class.getMethod("acos", Double.TYPE));
                this.put("math:asin", Math.class.getMethod("asin", Double.TYPE));
                this.put("math:atan", Math.class.getMethod("atan", Double.TYPE));
                this.put("math:ceil", Math.class.getMethod("ceil", Double.TYPE));
                this.put("math:cos", Math.class.getMethod("cos", Double.TYPE));
                this.put("math:exp", Math.class.getMethod("exp", Double.TYPE));
                this.put("math:floor", Math.class.getMethod("floor", Double.TYPE));
                this.put("math:log", Math.class.getMethod("log", Double.TYPE));
                this.put("math:log10", Math.class.getMethod("log10", Double.TYPE));
                this.put("math:maxInt32", Math.class.getMethod("max", Integer.TYPE, Integer.TYPE));
                this.put("math:maxInt64", Math.class.getMethod("max", Long.TYPE, Long.TYPE));
                this.put("math:maxFloat32", Math.class.getMethod("max", Float.TYPE, Float.TYPE));
                this.put("math:maxFloat64", Math.class.getMethod("max", Double.TYPE, Double.TYPE));
                this.put("math:minInt32", Math.class.getMethod("min", Integer.TYPE, Integer.TYPE));
                this.put("math:minInt64", Math.class.getMethod("min", Long.TYPE, Long.TYPE));
                this.put("math:minFloat32", Math.class.getMethod("min", Float.TYPE, Float.TYPE));
                this.put("math:minFloat64", Math.class.getMethod("min", Double.TYPE, Double.TYPE));
                this.put("math:pow", Math.class.getMethod("pow", Double.TYPE, Double.TYPE));
                this.put("math:sin", Math.class.getMethod("sin", Double.TYPE));
                this.put("math:sqrt", Math.class.getMethod("sqrt", Double.TYPE));
                this.put("math:tan", Math.class.getMethod("tan", Double.TYPE));
                this.put("path:random", RandomPath.class.getMethod("get", Integer.TYPE, Integer.TYPE));
                this.put("string:format", Language.class.getMethod("format", String.class, Object[].class));
                this.put("string:join", String.class.getMethod("join", CharSequence.class, CharSequence[].class));
                this.put("time:millisSinceEpoch", System.class.getMethod("currentTimeMillis", new Class[0]));
                this.put("time:nanos", System.class.getMethod("nanoTime", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
    };
    public static final Map<String, Value> VALUES = new HashMap<String, Value>(){
        {
            this.put("e", new Value(Math.E, Double.TYPE));
            this.put("lineSep", new Value(System.lineSeparator(), String.class));
            this.put("pathSep", new Value(File.pathSeparator, String.class));
            this.put("pi", new Value(Math.PI, Double.TYPE));
            this.put("rnd", new Value(new Random(), Random.class));
        }
    };

    public static String format(String pattern, Object ... args) {
        return CompositeExpressionInputBuilderImpl.FORMATTER.format(pattern, args).toString();
    }

    public static long xor(long x1, long x2) {
        return x1 ^ x2;
    }

    public static ExpressionInput.Builder withLanguage(ExpressionInput.Builder builder) {
        Object name;
        for (Map.Entry<String, Method> entry : FUNCTIONS.entrySet()) {
            name = entry.getKey().split(FUNC_NAME_SEPARATOR);
            Method method = entry.getValue();
            builder.function(name[0], name[1], method);
        }
        for (Map.Entry<String, Object> entry : VALUES.entrySet()) {
            name = entry.getKey();
            Value v = (Value)entry.getValue();
            builder.value((String)name, v.value, v.type);
        }
        return builder;
    }

    public static final class Value {
        final Object value;
        final Class type;

        Value(Object value, Class type) {
            this.value = value;
            this.type = type;
        }
    }
}

