/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.control;

import com.emc.mongoose.base.config.ConfigUtil;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.io.yaml.TypeNames;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfigServlet
extends HttpServlet {
    private static final String SCHEMA_PATH = "schema";
    private static final String CONTEXT_SEP = "/";
    private final Config config;

    public ConfigServlet(Config config) {
        this.config = config;
    }

    @Override
    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] contexts = req.getRequestURI().split(CONTEXT_SEP);
        if (contexts.length == 2) {
            this.getConfig(resp);
        } else if (contexts[2].equals(SCHEMA_PATH)) {
            this.getSchema(resp);
        } else {
            resp.setStatus(400);
            resp.getWriter().print("<ERROR> Such URI not found : " + req.getRequestURI());
        }
    }

    private void getSchema(HttpServletResponse resp) throws IOException {
        String schemaStr = ConfigUtil.writerWithPrettyPrinter(new YAMLMapper()).writeValueAsString(this.config.schema());
        for (String k : TypeNames.MAP.keySet()) {
            String v = TypeNames.MAP.get(k).getTypeName();
            schemaStr = schemaStr.replaceAll(v, k);
        }
        resp.setStatus(200);
        PrintWriter respWriter = resp.getWriter();
        respWriter.print(schemaStr);
    }

    private void getConfig(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        PrintWriter respWriter = resp.getWriter();
        respWriter.print(ConfigUtil.toString(this.config));
    }
}

