/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.DataItemFactory;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.io.CsvItemInput;
import com.github.akurilov.commons.io.file.FileInput;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class CsvFileItemInput<I extends Item>
extends CsvItemInput<I>
implements FileInput<I> {
    protected final Path itemsFilePath;

    public CsvFileItemInput(Path itemsFilePath, ItemFactory<I> itemFactory) throws IOException, NoSuchMethodException {
        super(Files.newBufferedReader(itemsFilePath, StandardCharsets.UTF_8), itemFactory);
        this.itemsFilePath = itemsFilePath;
    }

    @Override
    public String toString() {
        return (this.itemFactory instanceof DataItemFactory ? "Data" : "") + "ItemsFromFile(" + this.itemsFilePath + ")";
    }

    @Override
    public final Path filePath() {
        return this.itemsFilePath;
    }

    @Override
    public void reset() {
        try {
            if (this.itemsSrc != null) {
                this.itemsSrc.close();
            }
            this.setItemsSrc(Files.newBufferedReader(this.itemsFilePath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }
}

