/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.io.CsvFileItemInput;
import com.emc.mongoose.base.item.io.CsvItemOutput;
import com.github.akurilov.commons.io.file.FileOutput;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class CsvFileItemOutput<I extends Item>
extends CsvItemOutput<I>
implements FileOutput<I> {
    protected Path itemsFilePath;

    public CsvFileItemOutput(Path itemsFilePath, ItemFactory<I> itemFactory) throws IOException {
        super(Files.newOutputStream(itemsFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE), itemFactory);
        this.itemsFilePath = itemsFilePath;
    }

    public CsvFileItemOutput(ItemFactory<I> itemFactory) throws IOException {
        this(Files.createTempFile(null, ".csv", new FileAttribute[0]), itemFactory);
        this.itemsFilePath.toFile().deleteOnExit();
    }

    @Override
    public CsvFileItemInput<I> getInput() {
        try {
            return new CsvFileItemInput(this.itemsFilePath, this.itemFactory);
        }
        catch (IOException | NoSuchMethodException e) {
            Exceptions.throwUnchecked(e);
            return null;
        }
    }

    @Override
    public String toString() {
        return "csvFileItemOutput<" + this.itemsFilePath.getFileName() + ">";
    }

    @Override
    public final Path filePath() {
        return this.itemsFilePath;
    }
}

