/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.Level;

public class CsvItemInput<I extends Item>
implements Input<I> {
    protected BufferedReader itemsSrc;
    protected final ItemFactory<I> itemFactory;

    public CsvItemInput(InputStream in, ItemFactory<I> itemFactory) {
        this(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8), 0x100000), itemFactory);
    }

    protected CsvItemInput(BufferedReader itemsSrc, ItemFactory<I> itemFactory) {
        this.setItemsSrc(itemsSrc);
        this.itemFactory = itemFactory;
    }

    protected final void setItemsSrc(BufferedReader itemsSrc) {
        this.itemsSrc = itemsSrc;
    }

    @Override
    public long skip(long itemsCount) {
        long i;
        try {
            for (i = 0L; i < itemsCount && null != this.itemsSrc.readLine(); ++i) {
            }
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        return i;
    }

    @Override
    public I get() {
        try {
            String nextLine = this.itemsSrc.readLine();
            try {
                return nextLine == null ? null : (I)this.itemFactory.getItem(nextLine);
            }
            catch (IllegalArgumentException e) {
                LogUtil.trace(Loggers.ERR, Level.WARN, e, "Failed to build the item from the string \"{}\"", nextLine);
            }
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        return null;
    }

    @Override
    public int get(List<I> buffer, int limit) {
        int i;
        String nextLine = null;
        try {
            for (i = 0; i < limit; ++i) {
                nextLine = this.itemsSrc.readLine();
                if (nextLine == null) {
                    if (i == 0) {
                        throw new EOFException();
                    }
                    break;
                }
                buffer.add(this.itemFactory.getItem(nextLine));
            }
        }
        catch (IllegalArgumentException e) {
            LogUtil.trace(Loggers.ERR, Level.WARN, e, "Failed to build the item from the string \"{}\"", nextLine);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        return i;
    }

    @Override
    public void reset() {
        try {
            this.itemsSrc.reset();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void close() {
        try {
            this.itemsSrc.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    public String toString() {
        return "csvItemInput<" + this.itemsSrc + ">";
    }
}

