/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.DataItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class DataItemInputStream
extends InputStream {
    private final DataItem dataItem;
    private final long dataSize;
    private long doneSize = 0L;
    private long markPos = 0L;
    private ByteBuffer buffWrapper = null;
    private byte[] buff = null;

    public DataItemInputStream(DataItem dataItem) throws IOException {
        this.dataItem = dataItem;
        this.dataSize = dataItem.size();
    }

    @Override
    public final int read() throws IOException {
        if (0L < this.dataSize - this.doneSize) {
            this.buffWrapper = ByteBuffer.allocate(1);
            this.dataItem.read(this.buffWrapper);
            ++this.doneSize;
            return this.buffWrapper.get();
        }
        return -1;
    }

    @Override
    public final int read(byte[] buff, int offset, int length) throws IOException {
        if (0L < this.dataSize - this.doneSize) {
            if (buff != this.buff) {
                this.buffWrapper = ByteBuffer.wrap(buff);
            }
            this.buffWrapper.position(offset).limit(offset + length);
            int n = this.dataItem.read(this.buffWrapper);
            this.doneSize += (long)n;
            return n;
        }
        return -1;
    }

    @Override
    public final int available() {
        return (int)Math.min(Integer.MAX_VALUE, this.dataSize - this.doneSize);
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final void mark(int readLimit) {
        try {
            this.markPos = this.dataItem.position();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void reset() throws IOException {
        this.dataItem.position(this.markPos);
    }

    @Override
    public final void close() {
        this.buffWrapper = null;
        this.buff = null;
    }
}

