/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.data.DataCorruptionException;
import com.emc.mongoose.base.item.DataItem;
import com.github.akurilov.commons.io.ByteCountOutputStream;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class DataItemOutputStream
extends ByteCountOutputStream {
    private final DataItem dataItem;
    private ByteBuffer buffWrapper = null;
    private byte[] buff = null;

    public DataItemOutputStream(DataItem dataItem) {
        this.dataItem = dataItem;
    }

    @Override
    public final void write(int b) throws DataCorruptionException {
        this.buffWrapper = ByteBuffer.allocate(1);
        try {
            this.dataItem.read(this.buffWrapper);
            this.buffWrapper.rewind();
            this.dataItem.verify(this.buffWrapper);
            this.dataItem.position(this.dataItem.position() + 1L);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        this.byteCount.increment();
    }

    @Override
    public final void write(byte[] buff, int offset, int length) throws DataCorruptionException {
        if (buff != this.buff) {
            this.buffWrapper = ByteBuffer.wrap(buff);
        }
        this.buffWrapper.position(offset).limit(offset + length);
        this.dataItem.verify(this.buffWrapper);
        try {
            this.dataItem.position(this.dataItem.position() + (long)length);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        this.byteCount.add(length);
    }

    @Override
    public final void write(byte[] buff) throws DataCorruptionException {
        if (buff != this.buff) {
            this.buffWrapper = ByteBuffer.wrap(buff);
        }
        this.dataItem.verify(this.buffWrapper);
        try {
            this.dataItem.position(this.dataItem.position() + (long)buff.length);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        this.byteCount.add(buff.length);
    }

    @Override
    public final void close() throws IOException {
        this.buffWrapper = null;
        this.buff = null;
    }
}

