/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.env.FsUtil;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.io.file.TextFileOutput;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class ItemInfoFileOutput<I extends Item, O extends Operation>
implements Output<O> {
    private final Output<String> itemInfoOutput;

    public ItemInfoFileOutput(Path filePath) throws IOException {
        FsUtil.createParentDirsIfNotExist(filePath);
        this.itemInfoOutput = new TextFileOutput(filePath);
    }

    @Override
    public final boolean put(O ioResult) {
        if (ioResult == null) {
            try {
                this.close();
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
            return true;
        }
        return this.itemInfoOutput.put(ioResult.item().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int put(List<O> ioResults, int from, int to) {
        int n = to - from;
        ArrayList<String> itemsInfo = new ArrayList<String>(n);
        for (int i = from; i < to; ++i) {
            Operation ioResult = (Operation)ioResults.get(i);
            if (ioResult == null) {
                try {
                    int n2 = this.itemInfoOutput.put(itemsInfo, 0, i);
                    return n2;
                }
                finally {
                    try {
                        this.close();
                    }
                    catch (Exception e) {
                        Exceptions.throwUnchecked(e);
                    }
                }
            }
            itemsInfo.add(ioResult.item().toString());
        }
        return this.itemInfoOutput.put(itemsInfo, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int put(List<O> ioResults) {
        ArrayList<String> itemsInfo = new ArrayList<String>(ioResults.size());
        for (Operation nextIoResult : ioResults) {
            if (nextIoResult == null) {
                try {
                    int n = this.itemInfoOutput.put(itemsInfo);
                    return n;
                }
                finally {
                    try {
                        this.close();
                    }
                    catch (Exception e) {
                        Exceptions.throwUnchecked(e);
                    }
                }
            }
            itemsInfo.add(nextIoResult.item().toString());
        }
        return this.itemInfoOutput.put(itemsInfo);
    }

    @Override
    public final Input<O> getInput() {
        throw new AssertionError();
    }

    @Override
    public final void close() throws Exception {
        this.itemInfoOutput.close();
    }
}

