/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.naming;

import com.emc.mongoose.base.config.ConstantValueInputImpl;
import com.emc.mongoose.base.config.el.CompositeExpressionInputBuilder;
import com.emc.mongoose.base.item.naming.ItemNameInput;
import com.emc.mongoose.base.item.naming.ItemNameInputImpl;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.math.MathUtil;

public final class ItemNameInputBuilder
implements ItemNameInput.Builder {
    private volatile ItemNameInput.ItemNamingType type = ItemNameInput.ItemNamingType.RANDOM;
    private volatile int radix = 36;
    private volatile String prefix = null;
    private volatile int length = 12;
    private volatile long seed = 0L;
    private volatile int step = 1;

    public final ItemNameInputBuilder type(ItemNameInput.ItemNamingType type) {
        this.type = type;
        return this;
    }

    public final ItemNameInputBuilder radix(int radix) {
        this.radix = radix;
        return this;
    }

    public final ItemNameInputBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public final ItemNameInputBuilder length(int length) {
        this.length = length;
        return this;
    }

    public final ItemNameInputBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }

    public final ItemNameInputBuilder step(int step) {
        this.step = step;
        return this;
    }

    @Override
    public <T extends ItemNameInput> T build() {
        long maxId = (long)Math.pow(this.radix, this.length);
        Input<String> prefixInput = this.prefix == null ? new ConstantValueInputImpl<String>("") : CompositeExpressionInputBuilder.newInstance().expression(this.prefix).build();
        switch (this.type) {
            case RANDOM: {
                return (T)new ItemNameInputImpl(x -> Math.abs(MathUtil.xorShift(x) % maxId), this.seed, prefixInput, this.radix);
            }
            case SERIAL: {
                return (T)new ItemNameInputImpl(x -> Math.abs((x + (long)this.step) % maxId), this.seed, prefixInput, this.radix);
            }
        }
        return null;
    }
}

