/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.op;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.storage.Credential;

public class OperationImpl<I extends Item>
implements Operation<I> {
    protected int originIndex;
    protected OpType opType;
    protected I item;
    protected String srcPath;
    protected String dstPath;
    protected Credential credential;
    protected volatile String nodeAddr;
    protected volatile Operation.Status status;
    protected volatile long reqTimeStart;
    protected volatile long reqTimeDone;
    protected volatile long respTimeStart;
    protected volatile long respTimeDone;
    protected static final ThreadLocal<StringBuilder> STRB = ThreadLocal.withInitial(StringBuilder::new);

    public OperationImpl() {
    }

    public OperationImpl(int originIndex, OpType opType, I item, String srcPath, String dstPath, Credential credential) {
        this.originIndex = originIndex;
        this.opType = opType;
        this.item = item;
        String itemName = item.name();
        int lastSlashIndex = itemName.lastIndexOf("/");
        if (lastSlashIndex > 0 && lastSlashIndex < itemName.length()) {
            this.srcPath = itemName.substring(0, lastSlashIndex);
            item.name(itemName.substring(lastSlashIndex + 1));
        } else {
            this.srcPath = srcPath;
        }
        if (dstPath == null) {
            if (OpType.READ.equals((Object)opType) || OpType.UPDATE.equals((Object)opType) || OpType.DELETE.equals((Object)opType)) {
                this.dstPath = this.srcPath;
            }
        } else {
            this.dstPath = dstPath;
        }
        this.credential = credential;
    }

    protected OperationImpl(OperationImpl<I> other) {
        this.originIndex = other.originIndex;
        this.opType = other.opType;
        this.item = other.item;
        this.srcPath = other.srcPath;
        this.dstPath = other.dstPath;
        this.credential = other.credential;
        this.nodeAddr = other.nodeAddr;
        this.status = other.status;
        this.reqTimeStart = other.reqTimeStart;
        this.reqTimeDone = other.reqTimeDone;
        this.respTimeStart = other.respTimeStart;
        this.respTimeDone = other.respTimeDone;
    }

    @Override
    public OperationImpl<I> result() {
        this.buildItemPath(this.item, this.dstPath == null ? this.srcPath : this.dstPath);
        return new OperationImpl<I>(this);
    }

    @Override
    public void reset() {
        this.item.reset();
        this.nodeAddr = null;
        this.status = Operation.Status.PENDING;
        this.respTimeDone = 0L;
        this.respTimeStart = 0L;
        this.reqTimeDone = 0L;
        this.reqTimeStart = 0L;
    }

    @Override
    public final int originIndex() {
        return this.originIndex;
    }

    @Override
    public final I item() {
        return this.item;
    }

    @Override
    public final OpType type() {
        return this.opType;
    }

    @Override
    public final String nodeAddr() {
        return this.nodeAddr;
    }

    @Override
    public final void nodeAddr(String nodeAddr) {
        this.nodeAddr = nodeAddr;
    }

    @Override
    public final Operation.Status status() {
        return this.status;
    }

    @Override
    public final void status(Operation.Status status) {
        this.status = status;
    }

    @Override
    public final String srcPath() {
        return this.srcPath;
    }

    @Override
    public final void srcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Override
    public final String dstPath() {
        return this.dstPath;
    }

    @Override
    public final void dstPath(String dstPath) {
        this.dstPath = dstPath;
    }

    @Override
    public final Credential credential() {
        return this.credential;
    }

    @Override
    public final void credential(Credential credential) {
        this.credential = credential;
    }

    @Override
    public final void startRequest() {
        this.reqTimeStart = START_OFFSET_MICROS + System.nanoTime() / 1000L;
        this.status = Operation.Status.ACTIVE;
    }

    @Override
    public final void finishRequest() {
        this.reqTimeDone = START_OFFSET_MICROS + System.nanoTime() / 1000L;
        if (this.respTimeStart > 0L) {
            throw new IllegalStateException("Request is finished (" + this.reqTimeDone + ") after the response is started (" + this.respTimeStart + ")");
        }
    }

    @Override
    public final void startResponse() {
        this.respTimeStart = START_OFFSET_MICROS + System.nanoTime() / 1000L;
        if (this.reqTimeDone > this.respTimeStart) {
            throw new IllegalStateException("Response is started (" + this.respTimeStart + ") before the request is finished (" + this.reqTimeDone + ")");
        }
    }

    @Override
    public void finishResponse() {
        this.respTimeDone = START_OFFSET_MICROS + System.nanoTime() / 1000L;
        if (this.respTimeStart == 0L) {
            throw new IllegalStateException("Response is finished while not started");
        }
    }

    @Override
    public final long reqTimeStart() {
        return this.reqTimeStart;
    }

    @Override
    public final long reqTimeDone() {
        return this.reqTimeDone;
    }

    @Override
    public final long respTimeStart() {
        return this.respTimeStart;
    }

    @Override
    public final long respTimeDone() {
        return this.respTimeDone;
    }

    @Override
    public final long duration() {
        return this.respTimeDone - this.reqTimeStart;
    }

    @Override
    public final long latency() {
        return this.respTimeStart - this.reqTimeDone;
    }

    public String toString() {
        StringBuilder strb = STRB.get();
        strb.setLength(0);
        return strb.append(this.opType.name()).append(',').append(this.item.toString()).append(',').append(this.dstPath == null ? "" : this.dstPath).append(',').toString();
    }

    public final int hashCode() {
        return this.originIndex ^ this.opType.ordinal() ^ this.item.hashCode();
    }
}

