/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.op;

import com.emc.mongoose.base.config.ConstantValueInput;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.OperationImpl;
import com.emc.mongoose.base.item.op.OperationsBuilder;
import com.emc.mongoose.base.storage.Credential;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class OperationsBuilderImpl<I extends Item, O extends Operation<I>>
implements OperationsBuilder<I, O> {
    protected final int originIndex;
    protected OpType opType = OpType.CREATE;
    protected String inputPath = null;
    protected Input<String> outputPathInput;
    protected boolean constOutputPathFlag;
    protected String constOutputPath;
    protected Input<Credential> credentialInput;
    protected boolean constCredFlag;
    protected Credential constCred;
    protected Map<String, Credential> credentialsByPath = null;

    public OperationsBuilderImpl(int originIndex) {
        this.originIndex = originIndex;
    }

    @Override
    public final int originIndex() {
        return this.originIndex;
    }

    @Override
    public final OpType opType() {
        return this.opType;
    }

    @Override
    public final OperationsBuilderImpl<I, O> opType(OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public final String inputPath() {
        return this.inputPath;
    }

    @Override
    public final OperationsBuilderImpl<I, O> inputPath(String inputPath) {
        this.inputPath = inputPath;
        return this;
    }

    @Override
    public final OperationsBuilderImpl<I, O> outputPathInput(Input<String> ops) {
        this.outputPathInput = ops;
        if (this.outputPathInput == null) {
            this.constOutputPathFlag = true;
            this.constOutputPath = null;
        } else if (this.outputPathInput instanceof ConstantValueInput) {
            this.constOutputPathFlag = true;
            this.constOutputPath = this.outputPathInput.get();
        } else {
            this.constOutputPathFlag = false;
        }
        return this;
    }

    @Override
    public final OperationsBuilderImpl<I, O> credentialInput(Input<Credential> credentialInput) {
        this.credentialInput = credentialInput;
        if (credentialInput == null) {
            this.constCredFlag = true;
            this.constCred = Credential.NONE;
        } else if (credentialInput instanceof ConstantValueInput) {
            this.constCredFlag = true;
            this.constCred = credentialInput.get();
        } else {
            this.constCredFlag = false;
        }
        return this;
    }

    @Override
    public OperationsBuilderImpl<I, O> credentialsByPath(Map<String, Credential> credByPath) {
        this.credentialsByPath = credByPath;
        return this;
    }

    @Override
    public O buildOp(I item) throws IOException {
        String outputPath = this.getNextOutputPath();
        return (O)new OperationImpl<I>(this.originIndex, this.opType, item, this.inputPath, outputPath, this.getNextCredential(outputPath));
    }

    @Override
    public void buildOps(List<I> items, List<O> buff) throws IOException {
        for (Item item : items) {
            String outputPath = this.getNextOutputPath();
            buff.add(new OperationImpl<Item>(this.originIndex, this.opType, item, this.inputPath, outputPath, this.getNextCredential(outputPath)));
        }
    }

    protected final String getNextOutputPath() {
        return this.constOutputPathFlag ? this.constOutputPath : this.outputPathInput.get();
    }

    protected final Credential getNextCredential(String path) {
        return this.constCredFlag ? this.constCred : this.credentialsByPath.get(path);
    }

    @Override
    public void close() {
        this.inputPath = null;
        try {
            if (this.outputPathInput != null) {
                this.outputPathInput.close();
                this.outputPathInput = null;
            }
            if (this.credentialInput != null) {
                this.credentialInput.close();
                this.credentialInput = null;
            }
            if (this.credentialsByPath != null) {
                this.credentialsByPath.clear();
                this.credentialsByPath = null;
            }
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }
}

