/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.generator;

import com.emc.mongoose.base.config.ConstantValueInputImpl;
import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.config.el.CompositeExpressionInputBuilder;
import com.emc.mongoose.base.config.el.Language;
import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.DataItemFactoryImpl;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.ItemType;
import com.emc.mongoose.base.item.TransferConvertBuffer;
import com.emc.mongoose.base.item.io.ItemInputFactory;
import com.emc.mongoose.base.item.io.NewDataItemInput;
import com.emc.mongoose.base.item.io.NewItemInput;
import com.emc.mongoose.base.item.naming.ItemNameInput;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.OperationsBuilder;
import com.emc.mongoose.base.item.op.data.DataOperationsBuilder;
import com.emc.mongoose.base.item.op.data.DataOperationsBuilderImpl;
import com.emc.mongoose.base.item.op.path.PathOperationsBuilderImpl;
import com.emc.mongoose.base.item.op.token.TokenOperationsBuilderImpl;
import com.emc.mongoose.base.load.generator.LoadGeneratorBuilder;
import com.emc.mongoose.base.load.generator.LoadGeneratorImpl;
import com.emc.mongoose.base.logging.LogContextThreadFactory;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.Credential;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.concurrent.throttle.IndexThrottle;
import com.github.akurilov.commons.concurrent.throttle.Throttle;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.io.el.ExpressionInput;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;

public class LoadGeneratorBuilderImpl<I extends Item, O extends Operation<I>, T extends LoadGeneratorImpl<I, O>>
implements LoadGeneratorBuilder<I, O, T> {
    private Config itemConfig = null;
    private Config loadConfig = null;
    private ItemType itemType = null;
    private ItemFactory<I> itemFactory = null;
    private Config authConfig = null;
    private Output<O> opOutput = null;
    private Input<I> itemInput = null;
    private long sizeEstimate = -1L;
    private int batchSize = -1;
    private int originIndex = -1;
    private final List<Object> throttles = new ArrayList<Object>();

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> itemConfig(Config itemConfig) {
        this.itemConfig = itemConfig;
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> loadConfig(Config loadConfig) {
        this.loadConfig = loadConfig;
        this.batchSize = loadConfig.intVal("batch-size");
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> itemType(ItemType itemType) {
        this.itemType = itemType;
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> itemFactory(ItemFactory<I> itemFactory) {
        this.itemFactory = itemFactory;
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> authConfig(Config authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> loadOperationsOutput(Output<O> opOutput) {
        this.opOutput = opOutput;
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> itemInput(Input<I> itemInput) {
        this.itemInput = itemInput;
        if (!(itemInput instanceof TransferConvertBuffer)) {
            this.sizeEstimate = LoadGeneratorBuilderImpl.estimateTransferSize(null, OpType.valueOf(this.loadConfig.stringVal("op-type").toUpperCase()), itemInput);
        }
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> originIndex(int originIndex) {
        this.originIndex = originIndex;
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> addThrottle(Throttle throttle) {
        this.throttles.add(throttle);
        return this;
    }

    @Override
    public LoadGeneratorBuilderImpl<I, O, T> addThrottle(IndexThrottle throttle) {
        this.throttles.add(throttle);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T build() throws IllegalConfigurationException {
        String itemDataRangesConcatConfig;
        OperationsBuilder opsBuilder;
        if (this.loadConfig == null) {
            throw new IllegalConfigurationException("Load config is not set");
        }
        Config opConfig = this.loadConfig.configVal("op");
        long countLimit = opConfig.longVal("limit-count");
        boolean shuffleFlag = opConfig.boolVal("shuffle");
        if (this.itemConfig == null) {
            throw new IllegalConfigurationException("Item config is not set");
        }
        Config inputConfig = this.itemConfig.configVal("input");
        Config rangesConfig = this.itemConfig.configVal("data-ranges");
        if (this.itemType == null) {
            throw new IllegalConfigurationException("Item type is not set");
        }
        if (this.originIndex < 0) {
            throw new IllegalConfigurationException("No origin index is set");
        }
        if (ItemType.DATA.equals((Object)this.itemType)) {
            List fixedRangesConfig = rangesConfig.listVal("fixed");
            List fixedRanges = fixedRangesConfig == null ? Collections.EMPTY_LIST : fixedRangesConfig.stream().map(Range::new).collect(Collectors.toList());
            Object sizeThresholdRaw = rangesConfig.val("threshold");
            long sizeThreshold = sizeThresholdRaw instanceof String ? SizeInBytes.toFixedSize((String)sizeThresholdRaw) : TypeUtil.typeConvert(sizeThresholdRaw, Long.TYPE);
            opsBuilder = ((DataOperationsBuilderImpl)((DataOperationsBuilderImpl)new DataOperationsBuilderImpl(this.originIndex).fixedRanges(fixedRanges)).randomRangesCount(rangesConfig.intVal("random"))).sizeThreshold(sizeThreshold);
        } else {
            opsBuilder = ItemType.PATH.equals((Object)this.itemType) ? new PathOperationsBuilderImpl(this.originIndex) : new TokenOperationsBuilderImpl(this.originIndex);
        }
        OpType opType = OpType.valueOf(opConfig.stringVal("type").toUpperCase());
        opsBuilder.opType(opType);
        Object itemInputPath = inputConfig.stringVal("path");
        if (itemInputPath != null && ((String)itemInputPath).indexOf(47) != 0) {
            itemInputPath = "/" + (String)itemInputPath;
        }
        opsBuilder.inputPath((String)itemInputPath);
        Input<String> outputPathSupplier = OpType.CREATE.equals((Object)opType) && ItemType.DATA.equals((Object)this.itemType) ? this.getOutputPathSupplier() : null;
        opsBuilder.outputPathInput(outputPathSupplier);
        if (this.authConfig == null) {
            throw new IllegalConfigurationException("Storage auth config is not set");
        }
        String authFile = this.authConfig.stringVal("file");
        if (authFile != null && !authFile.isEmpty()) {
            Map<String, Credential> credentials = LoadGeneratorBuilderImpl.loadCredentialsByPath(authFile, 1000000L);
            opsBuilder.credentialsByPath(credentials);
        } else {
            String uid = this.authConfig.stringVal("uid");
            String secret = this.authConfig.stringVal("secret");
            if (null == uid && null == secret) {
                opsBuilder.credentialInput(new ConstantValueInputImpl<Credential>(Credential.NONE));
            } else {
                opsBuilder.credentialInput(new ConstantValueInputImpl<Credential>(Credential.getInstance(uid, secret)));
            }
        }
        String itemInputFile = inputConfig.stringVal("file");
        if (this.itemInput == null) {
            if ((itemInputFile == null || itemInputFile.isEmpty()) && (itemInputPath == null || ((String)itemInputPath).isEmpty())) {
                this.itemInput = this.newItemInput();
            } else if (this.opOutput instanceof StorageDriver) {
                this.itemInput = ItemInputFactory.createItemInput(this.itemConfig, this.batchSize, (StorageDriver)this.opOutput);
            }
            if (this.itemInput == null) {
                throw new IllegalConfigurationException("No item input available");
            }
            this.sizeEstimate = ItemType.DATA.equals((Object)this.itemType) ? LoadGeneratorBuilderImpl.estimateTransferSize((DataOperationsBuilder)opsBuilder, opsBuilder.opType(), this.itemInput) : 4096L;
        }
        if (OpType.CREATE.equals((Object)opType) && ItemType.DATA.equals((Object)this.itemType) && !(this.itemInput instanceof NewItemInput) && (itemDataRangesConcatConfig = rangesConfig.stringVal("concat")) != null) {
            int srcItemsCount;
            Range srcItemsCountRange = new Range(itemDataRangesConcatConfig);
            long srcItemsCountMin = srcItemsCountRange.getBeg();
            long srcItemsCountMax = srcItemsCountRange.getEnd();
            if (srcItemsCountMin < 0L) {
                throw new IllegalConfigurationException("Source data items count min value should be more than 0");
            }
            if (srcItemsCountMax == 0L || srcItemsCountMax < srcItemsCountMin) {
                throw new IllegalConfigurationException("Source data items count max value should be more than 0 and not less than min value");
            }
            ArrayList srcItemsBuff = new ArrayList(1000000);
            try {
                srcItemsCount = LoadGeneratorBuilderImpl.loadSrcItems(this.itemInput, srcItemsBuff, 1000000);
            }
            finally {
                try {
                    this.itemInput.close();
                }
                catch (Exception exception) {}
            }
            if (srcItemsCount == 0) {
                throw new IllegalConfigurationException("Available source items count " + srcItemsCount + " should be more than 0");
            }
            if ((long)srcItemsCount < srcItemsCountMin) {
                throw new IllegalConfigurationException("Available source items count " + srcItemsCount + " is less than configured min " + srcItemsCountMin);
            }
            if ((long)srcItemsCount < srcItemsCountMax) {
                throw new IllegalConfigurationException("Available source items count " + srcItemsCount + " is less than configured max " + srcItemsCountMax);
            }
            ((DataOperationsBuilder)opsBuilder).srcItemsCount((int)srcItemsCountMin, (int)srcItemsCountMax);
            ((DataOperationsBuilder)opsBuilder).srcItemsForConcat(srcItemsBuff);
            this.itemInput = this.newItemInput();
        }
        if (this.opOutput == null) {
            throw new IllegalConfigurationException("Load operations output is not set");
        }
        if (this.sizeEstimate > 0L && ItemType.DATA.equals((Object)this.itemType) && this.opOutput instanceof StorageDriver) {
            ((StorageDriver)this.opOutput).adjustIoBuffers(this.sizeEstimate, opType);
        }
        boolean recycleFlag = opConfig.boolVal("recycle");
        boolean retryFlag = opConfig.boolVal("retry");
        int recycleLimit = opConfig.intVal("limit-recycle");
        if (recycleLimit < 1) {
            throw new IllegalConfigurationException("Recycle limit should be > 0");
        }
        return (T)new LoadGeneratorImpl(this.itemInput, opsBuilder, this.throttles, this.opOutput, this.batchSize, countLimit, recycleLimit, recycleFlag || retryFlag, shuffleFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long estimateTransferSize(DataOperationsBuilder dataOpBuilder, OpType opType, Input<DataItem> itemInput) {
        int n;
        ArrayList items;
        long itemSize;
        List<Range> fixedRanges;
        int randomRangesCount;
        long sizeThreshold;
        block29: {
            sizeThreshold = 0L;
            randomRangesCount = 0;
            fixedRanges = null;
            if (dataOpBuilder != null) {
                sizeThreshold = dataOpBuilder.sizeThreshold();
                randomRangesCount = dataOpBuilder.randomRangesCount();
                fixedRanges = dataOpBuilder.fixedRanges();
            }
            itemSize = 0L;
            int maxCount = 256;
            items = new ArrayList(256);
            try {
                for (n = 0; n < 256; n += itemInput.get(items, 256 - n)) {
                }
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    if (!(e instanceof EOFException)) {
                        LogUtil.exception(Level.WARN, e, "Failed to estimate the average data item size", new Object[0]);
                    }
                    break block29;
                }
                throw e;
            }
            finally {
                try {
                    itemInput.reset();
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        LogUtil.exception(Level.WARN, e, "Failed reset the items input", new Object[0]);
                    }
                    throw e;
                }
            }
        }
        long sumSize = 0L;
        long minSize = Long.MAX_VALUE;
        long maxSize = Long.MIN_VALUE;
        if (n > 0) {
            try {
                for (int i = 0; i < n; ++i) {
                    long nextSize = ((DataItem)items.get(i)).size();
                    sumSize += nextSize;
                    if (nextSize < minSize) {
                        minSize = nextSize;
                    }
                    if (nextSize <= maxSize) continue;
                    maxSize = nextSize;
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            itemSize = minSize == maxSize ? sumSize / (long)n : (minSize + maxSize) / 2L;
        }
        switch (opType) {
            case CREATE: {
                return Math.min(itemSize, sizeThreshold);
            }
            case READ: 
            case UPDATE: {
                if (itemSize > 0L && randomRangesCount > 0) {
                    return itemSize * (long)randomRangesCount / (long)DataItem.rangeCount(itemSize);
                }
                if (fixedRanges != null && !fixedRanges.isEmpty()) {
                    long sizeSum = 0L;
                    for (Range byteRange : fixedRanges) {
                        long rangeSize = byteRange.getSize();
                        if (rangeSize == -1L) {
                            rangeSize = byteRange.getEnd() - byteRange.getBeg() + 1L;
                        }
                        if (rangeSize <= 0L) continue;
                        sizeSum += rangeSize;
                    }
                    return sizeSum;
                }
                return itemSize;
            }
        }
        return 0L;
    }

    private Input<String> getOutputPathSupplier() {
        String path = this.itemConfig.stringVal("output-path");
        Input<String> pathInput = path.contains("#{") || path.contains("${") || path.contains("%{") ? CompositeExpressionInputBuilder.newInstance().expression(path).build() : new ConstantValueInputImpl<String>(path);
        return pathInput;
    }

    private Input<I> newItemInput() throws IllegalConfigurationException {
        Config namingConfig = this.itemConfig.configVal("naming");
        int length = namingConfig.intVal("length");
        Object seedRaw = namingConfig.val("seed");
        long seed = 0L;
        try {
            seed = TypeUtil.typeConvert(seedRaw, Long.TYPE);
        }
        catch (ClassCastException | NumberFormatException e) {
            if (seedRaw instanceof String) {
                try (Object in = Language.withLanguage(ExpressionInput.builder()).expression((String)seedRaw).build();){
                    seed = (Long)in.get();
                }
                catch (Exception ee) {
                    LogUtil.exception(Level.WARN, e, "Item naming seed expression (\"{}\") failure", seedRaw);
                }
            }
            throw new IllegalStateException("Item naming seed (" + seedRaw + ") should be an integer either an expression");
        }
        String prefix = namingConfig.stringVal("prefix");
        int radix = namingConfig.intVal("radix");
        int step = namingConfig.intVal("step");
        ItemNameInput.ItemNamingType type = ItemNameInput.ItemNamingType.valueOf(namingConfig.stringVal("type").toUpperCase());
        Object itemNameInput = ItemNameInput.Builder.newInstance().length(length).seed(seed).prefix(prefix).radix(radix).step(step).type(type).build();
        if (this.itemFactory == null) {
            throw new IllegalConfigurationException("Item factory is not set");
        }
        if (this.itemFactory instanceof DataItemFactoryImpl) {
            Object itemDataSizeRaw = this.itemConfig.val("data-size");
            SizeInBytes itemDataSize = itemDataSizeRaw instanceof String ? new SizeInBytes((String)itemDataSizeRaw) : new SizeInBytes(TypeUtil.typeConvert(itemDataSizeRaw, Long.TYPE));
            this.itemInput = new NewDataItemInput<I>(this.itemFactory, (ItemNameInput)itemNameInput, itemDataSize);
        } else {
            this.itemInput = new NewItemInput<I>(this.itemFactory, (ItemNameInput)itemNameInput);
        }
        return this.itemInput;
    }

    private static Map<String, Credential> loadCredentialsByPath(String file, long countLimit) {
        HashMap<String, Credential> credByPath = new HashMap<String, Credential>();
        try (BufferedReader br = Files.newBufferedReader(Paths.get(file, new String[0]));){
            String line;
            for (long count = 0L; null != (line = br.readLine()) && count < countLimit; ++count) {
                String[] parts = line.split(",", 3);
                credByPath.put(parts[0], Credential.getInstance(parts[1], parts[2]));
            }
            Loggers.MSG.info("Loaded {} credential pairs from the file \"{}\"", (Object)credByPath.size(), (Object)file);
        }
        catch (Exception e) {
            LogUtil.exception(Level.WARN, e, "Failed to load the credentials from the file \"{}\"", file);
        }
        return credByPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <I extends Item> int loadSrcItems(Input<I> itemInput, List<I> itemBuff, int countLimit) {
        LongAdder loadedCount = new LongAdder();
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, new LogContextThreadFactory("loadSrcItemsWorker", true));
        CountDownLatch finishLatch = new CountDownLatch(1);
        try {
            executor.submit(() -> {
                block9: {
                    int n;
                    try {
                        int m;
                        for (n = 0; n < countLimit; n += m) {
                            m = itemInput.get(itemBuff, countLimit - n);
                            if (m < 0) {
                                Loggers.MSG.info("Loaded {} items, limit reached", (Object)n);
                                break;
                            }
                            loadedCount.add(m);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof EOFException) {
                            Loggers.MSG.info("Loaded {} items, end of items input", (Object)n);
                            break block9;
                        }
                        if (e instanceof IOException) {
                            LogUtil.exception(Level.WARN, e, "Loaded {} items, I/O failure occurred", n);
                            break block9;
                        }
                        throw e;
                    }
                    finally {
                        finishLatch.countDown();
                    }
                }
            });
            executor.scheduleAtFixedRate(() -> Loggers.MSG.info("Loaded {} items from the input...", (Object)loadedCount.sum()), 0L, 10L, TimeUnit.SECONDS);
            finishLatch.await();
        }
        catch (InterruptedException e) {
            Exceptions.throwUnchecked(e);
        }
        finally {
            executor.shutdownNow();
        }
        return loadedCount.intValue();
    }
}

