/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.client.metrics;

import com.emc.mongoose.base.load.step.LoadStep;
import com.emc.mongoose.base.load.step.client.metrics.MetricsAggregator;
import com.emc.mongoose.base.load.step.client.metrics.MetricsSnapshotsSupplierTask;
import com.emc.mongoose.base.load.step.client.metrics.MetricsSnapshotsSupplierTaskImpl;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.github.akurilov.commons.concurrent.AsyncRunnableBase;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public final class MetricsAggregatorImpl
extends AsyncRunnableBase
implements MetricsAggregator {
    private final String loadStepId;
    private final MetricsSnapshotsSupplierTask[] snapshotSuppliers;
    private final int count;

    public MetricsAggregatorImpl(String loadStepId, List<LoadStep> stepSlices) {
        this.loadStepId = loadStepId;
        this.snapshotSuppliers = stepSlices.stream().map(MetricsSnapshotsSupplierTaskImpl::new).collect(Collectors.toList()).toArray(new MetricsSnapshotsSupplierTask[0]);
        this.count = this.snapshotSuppliers.length;
    }

    @Override
    public final List<AllMetricsSnapshot> metricsSnapshotsByIndex(int originIndex) {
        ArrayList<AllMetricsSnapshot> snapshotsByIndex = new ArrayList<AllMetricsSnapshot>(this.count);
        for (int i = 0; i < this.count; ++i) {
            AllMetricsSnapshot snapshot;
            MetricsSnapshotsSupplierTask supplyTask = this.snapshotSuppliers[i];
            List snapshots = (List)supplyTask.get();
            if (originIndex >= snapshots.size() || null == (snapshot = (AllMetricsSnapshot)snapshots.get(originIndex))) continue;
            snapshotsByIndex.add(snapshot);
        }
        return snapshotsByIndex;
    }

    @Override
    protected final void doStart() {
        Arrays.stream(this.snapshotSuppliers).forEach(snapshotsSupplier -> {
            try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId).put("class_name", this.getClass().getSimpleName());){
                snapshotsSupplier.start();
            }
            catch (RemoteException e) {
                LogUtil.exception(Level.ERROR, e, "{}: failed to start the metrics snapshots supplier task", this.loadStepId);
            }
        });
    }

    @Override
    protected final void doStop() {
        ((Stream)Arrays.stream(this.snapshotSuppliers).parallel()).forEach(snapshotsSupplier -> {
            try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId).put("class_name", this.getClass().getSimpleName());){
                snapshotsSupplier.stop();
            }
            catch (IOException e) {
                LogUtil.exception(Level.WARN, e, "{}: failed to stop the metrics snapshot supplier", this.loadStepId);
            }
        });
    }

    @Override
    protected final void doClose() {
        for (int i = 0; i < this.count; ++i) {
            try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId).put("class_name", this.getClass().getSimpleName());){
                this.snapshotSuppliers[i].close();
            }
            catch (IOException e) {
                LogUtil.exception(Level.WARN, e, "{}: failed to close the metrics snapshot supplier", this.loadStepId);
            }
            this.snapshotSuppliers[i] = null;
        }
    }
}

