/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.logging;

import com.emc.mongoose.base.Exceptions;
import com.github.akurilov.commons.concurrent.ContextAwareThreadFactory;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.ThreadContext;

public final class LogContextThreadFactory
extends ContextAwareThreadFactory {
    private static final Logger LOG = Logger.getLogger(LogContextThreadFactory.class.getName());

    public LogContextThreadFactory(String threadNamePrefix) {
        super(threadNamePrefix, ThreadContext.getContext());
    }

    public LogContextThreadFactory(String threadNamePrefix, boolean daemonFlag) {
        super(threadNamePrefix, daemonFlag, ThreadContext.getContext());
    }

    @Override
    public final Thread newThread(Runnable task) {
        return new LogContextThread(task, this.threadNamePrefix + "#" + this.threadNumber.incrementAndGet(), this.daemonFlag, exceptionHandler, this.threadContext);
    }

    private static final class LogContextThread
    extends ContextAwareThreadFactory.ContextAwareThread {
        private LogContextThread(Runnable task, String name, boolean daemonFlag, Thread.UncaughtExceptionHandler exceptionHandler, Map<String, String> threadContext) {
            super(task, name, daemonFlag, exceptionHandler, threadContext);
        }

        @Override
        public final void run() {
            try (CloseableThreadContext.Instance ctx = CloseableThreadContext.putAll(this.threadContext);){
                super.run();
            }
            catch (Throwable cause) {
                Exceptions.throwUncheckedIfInterrupted(cause);
                LOG.log(Level.SEVERE, "Unhandled thread failure", cause);
            }
        }
    }
}

