/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.logging;

import com.emc.mongoose.base.Constants;
import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.concurrent.DaemonBase;
import com.emc.mongoose.base.env.DateUtil;
import com.emc.mongoose.base.logging.Loggers;
import java.util.Calendar;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.util.datetime.DatePrinter;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.message.Message;

public interface LogUtil {
    public static final DatePrinter FMT_DT = FastDateFormat.getInstance("yyyyMMdd.HHmmss.SSS", DateUtil.TZ_UTC, Constants.LOCALE_DEFAULT);
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33";
    public static final String BLUE = "\u001b[34m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37;1m";
    public static final String RESET = "\u001b[0m";
    public static final String NOOP_COLOR = "\u001b[38;5;101m";
    public static final String CREATE_COLOR = "\u001b[38;5;67m";
    public static final String READ_COLOR = "\u001b[38;5;65m";
    public static final String UPDATE_COLOR = "\u001b[38;5;104m";
    public static final String DELETE_COLOR = "\u001b[38;5;137m";
    public static final String LIST_COLOR = "\u001b[38;5;138m";
    public static final ThreadLocal<StringBuilder> THR_LOC_MSG_BUILDER = ThreadLocal.withInitial(StringBuilder::new);

    public static String getDateTimeStamp() {
        return FMT_DT.format(Calendar.getInstance(DateUtil.TZ_UTC, Constants.LOCALE_DEFAULT).getTime());
    }

    public static void init(String homeDir, String initialStepId) {
        ThreadContext.put("home_dir", homeDir);
        ThreadContext.put("step_id", initialStepId);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("logCtxShutDownHook"){

                @Override
                public final void run() {
                    LogUtil.shutdown();
                }
            });
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void flushAll() {
        LoggerContext logCtx = (LoggerContext)LogManager.getContext();
        for (org.apache.logging.log4j.core.Logger logger : logCtx.getLoggers()) {
            for (Appender appender : logger.getAppenders().values()) {
                if (!(appender instanceof AbstractOutputStreamAppender)) continue;
                ((OutputStreamManager)((AbstractOutputStreamAppender)appender).getManager()).flush();
            }
        }
    }

    public static void shutdown() {
        try {
            DaemonBase.closeAll();
        }
        catch (Throwable cause) {
            Exceptions.throwUncheckedIfInterrupted(cause);
            cause.printStackTrace(System.err);
        }
        finally {
            LogManager.shutdown();
        }
    }

    public static String getFailureRatioAnsiColorCode(long succ, long fail) {
        if (fail == 0L) {
            return "\u001b[38;2;0;200;0m";
        }
        if (fail >= succ) {
            return "\u001b[38;2;" + (int)(200.0 + 55.0 * (double)fail / (double)(succ + fail)) + ";0;0m";
        }
        return "\u001b[38;2;" + (int)(400.0 * Math.sqrt((double)fail / (double)(succ + fail))) + ";" + (int)(200.0 * (double)succ / (double)(succ + fail)) + ";0m";
    }

    public static void exception(Level level, Throwable e, String msgPattern, Object ... args) {
        if (Loggers.ERR.isTraceEnabled()) {
            LogUtil.trace(Loggers.ERR, level, e, msgPattern, args);
        } else {
            StringBuilder msgBuilder = THR_LOC_MSG_BUILDER.get();
            msgBuilder.setLength(0);
            msgBuilder.append(msgPattern).append("\n\tCAUSE: ").append(e);
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                msgBuilder.append("\n\tCAUSE: ").append(cause.toString());
            }
            Message msg = Loggers.ERR.getMessageFactory().newMessage(msgBuilder.toString(), args);
            Loggers.ERR.log(level, msg);
        }
    }

    public static void trace(Logger logger, Level level, Throwable e, String msgPattern, Object ... args) {
        logger.log(level, logger.getMessageFactory().newMessage(msgPattern + ": " + e, args), e);
    }
}

