/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.logging;

import com.emc.mongoose.base.env.DateUtil;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.logging.LogMessageBase;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.text.StrBuilder;

public class MetricsAsciiTableLogMessage
extends LogMessageBase {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String TABLE_HEADER = "------------------------------------------------------------------------------------------------------------------------" + LINE_SEPARATOR + " Step Id  | Timestamp  |  Op  |     Concurrency     |       Count       | Step  |   Last Rate    |  Mean    |   Mean    " + LINE_SEPARATOR + " (last 10 |            | type |---------------------|-------------------| Time  |----------------| Latency  | Duration  " + LINE_SEPARATOR + " symbols) |yyMMddHHmmss|      | Current  |   Mean   |   Success  |Failed|  [s]  | [op/s] |[MB/s] |  [us]    |   [us]    " + LINE_SEPARATOR + "----------|------------|------|----------|----------|------------|------|-------|--------|-------|----------|-----------" + LINE_SEPARATOR;
    public static final String TABLE_BORDER_VERTICAL = "|";
    public static final int TABLE_HEADER_PERIOD = 20;
    private static volatile long ROW_OUTPUT_COUNTER = 0L;
    private final Set<MetricsContext> metrics;
    private volatile String formattedMsg = null;

    public MetricsAsciiTableLogMessage(Set<MetricsContext> metrics) {
        this.metrics = metrics;
    }

    @Override
    public final void formatTo(StringBuilder buffer) {
        if (this.formattedMsg == null) {
            StrBuilder strb = new StrBuilder();
            for (MetricsContext metricsCtx : this.metrics) {
                Object snapshot = metricsCtx.lastSnapshot();
                if (snapshot == null) continue;
                long succCount = snapshot.successSnapshot().count();
                long failCount = snapshot.failsSnapshot().count();
                OpType opType = metricsCtx.opType();
                boolean stdOutColorFlag = metricsCtx.stdOutColorEnabled();
                if (0L == ROW_OUTPUT_COUNTER % 20L) {
                    strb.append(TABLE_HEADER);
                }
                ++ROW_OUTPUT_COUNTER;
                strb.appendFixedWidthPadLeft(metricsCtx.id(), 10, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft(DateUtil.FMT_DATE_METRICS_TABLE.format(new Date()), 12, ' ').append(TABLE_BORDER_VERTICAL);
                if (stdOutColorFlag) {
                    switch (opType) {
                        case NOOP: {
                            strb.append("\u001b[38;5;101m");
                            break;
                        }
                        case CREATE: {
                            strb.append("\u001b[38;5;67m");
                            break;
                        }
                        case READ: {
                            strb.append("\u001b[38;5;65m");
                            break;
                        }
                        case UPDATE: {
                            strb.append("\u001b[38;5;104m");
                            break;
                        }
                        case DELETE: {
                            strb.append("\u001b[38;5;137m");
                            break;
                        }
                        case LIST: {
                            strb.append("\u001b[38;5;138m");
                        }
                    }
                }
                strb.appendFixedWidthPadRight(metricsCtx.opType().name(), 6, ' ');
                if (stdOutColorFlag) {
                    strb.append("\u001b[0m");
                }
                strb.append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft(snapshot.concurrencySnapshot().last(), 10, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadRight(MetricsAsciiTableLogMessage.formatFixedWidth(snapshot.concurrencySnapshot().mean(), 10), 10, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft(succCount, 12, ' ').append(TABLE_BORDER_VERTICAL);
                if (stdOutColorFlag) {
                    strb.append(LogUtil.getFailureRatioAnsiColorCode(succCount, failCount));
                }
                strb.appendFixedWidthPadLeft(failCount, 6, ' ');
                if (stdOutColorFlag) {
                    strb.append("\u001b[0m");
                }
                strb.append(TABLE_BORDER_VERTICAL).appendFixedWidthPadRight((double)snapshot.elapsedTimeMillis() / 1000.0, 7, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadRight(MetricsAsciiTableLogMessage.formatFixedWidth(snapshot.successSnapshot().last(), 8), 8, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadRight(MetricsAsciiTableLogMessage.formatFixedWidth(snapshot.byteSnapshot().last() / 1048576.0, 7), 7, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft((long)snapshot.latencySnapshot().mean(), 10, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft((long)snapshot.durationSnapshot().mean(), 11, ' ').appendNewLine();
            }
            this.formattedMsg = strb.toString();
        }
        buffer.append(this.formattedMsg);
    }
}

