/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.logging;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;

public final class OperationTraceRecord<I extends Item, O extends Operation<I>> {
    protected final String storageNode;
    protected final String itemPath;
    protected final int opTypeCode;
    protected final int statusCode;
    protected final long reqTimeStart;
    protected final long duration;
    protected final long respLatency;
    protected final long dataLatency;
    protected final long transferSize;

    public OperationTraceRecord(O opResult) {
        int commaPos;
        this.storageNode = opResult.nodeAddr();
        String itemInfo = opResult.item().toString();
        this.itemPath = itemInfo != null ? ((commaPos = itemInfo.indexOf(44, 0)) > 0 ? itemInfo.substring(0, itemInfo.indexOf(44, 0)) : itemInfo) : null;
        this.opTypeCode = opResult.type().ordinal();
        this.statusCode = opResult.status().ordinal();
        this.reqTimeStart = opResult.reqTimeStart();
        this.duration = opResult.respTimeDone() - this.reqTimeStart;
        long t = opResult.respTimeStart() - opResult.reqTimeDone();
        long l = this.respLatency = t < this.duration && t > 0L ? t : -1L;
        if (opResult instanceof DataOperation) {
            DataOperation dataIoResult = (DataOperation)opResult;
            t = opResult.reqTimeDone() - dataIoResult.respDataTimeStart();
            this.dataLatency = t < this.duration && t > 0L ? t : -1L;
            this.transferSize = dataIoResult.countBytesDone();
        } else {
            this.dataLatency = -1L;
            this.transferSize = -1L;
        }
    }

    public final void format(StringBuilder strb) {
        if (this.storageNode != null) {
            strb.append(this.storageNode);
        }
        strb.append(',');
        if (this.itemPath != null) {
            strb.append(this.itemPath);
        }
        strb.append(',');
        if (this.opTypeCode != -1) {
            strb.append(this.opTypeCode);
        }
        strb.append(',');
        if (this.statusCode != -1) {
            strb.append(this.statusCode);
        }
        strb.append(',');
        if (this.reqTimeStart > 0L) {
            strb.append(this.reqTimeStart);
        }
        strb.append(',');
        if (this.duration > 0L) {
            strb.append(this.duration);
        }
        strb.append(',');
        if (this.respLatency > 0L) {
            strb.append(this.respLatency);
        }
        strb.append(',');
        if (this.dataLatency > 0L) {
            strb.append(this.dataLatency);
        }
        strb.append(',');
        if (this.transferSize != -1L) {
            strb.append(this.transferSize);
        }
        strb.append('\n');
    }
}

