/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.context;

import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.metrics.DistributedMetricsListener;
import com.emc.mongoose.base.metrics.context.DistributedContextBuilder;
import com.emc.mongoose.base.metrics.context.DistributedMetricsContext;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.metrics.context.MetricsContextBase;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshotImpl;
import com.emc.mongoose.base.metrics.snapshot.DistributedAllMetricsSnapshot;
import com.emc.mongoose.base.metrics.snapshot.DistributedAllMetricsSnapshotImpl;
import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshotImpl;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshotImpl;
import com.github.akurilov.commons.system.SizeInBytes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class DistributedMetricsContextImpl<S extends DistributedAllMetricsSnapshotImpl>
extends MetricsContextBase<S>
implements DistributedMetricsContext<S> {
    private final IntSupplier nodeCountSupplier;
    private final Supplier<List<AllMetricsSnapshot>> snapshotsSupplier;
    private final boolean avgPersistFlag;
    private final boolean sumPersistFlag;
    private volatile DistributedMetricsListener metricsListener = null;
    private final List<Double> quantileValues;
    private final List<String> nodeAddrs;

    public DistributedMetricsContextImpl(String id, OpType opType, IntSupplier nodeCountSupplier, int concurrencyLimit, int concurrencyThreshold, SizeInBytes itemDataSize, int updateIntervalSec, boolean stdOutColorFlag, boolean avgPersistFlag, boolean sumPersistFlag, Supplier<List<AllMetricsSnapshot>> snapshotsSupplier, List<Double> quantileValues, List<String> nodeAddrs, String comment) {
        super(id, opType, concurrencyLimit, nodeCountSupplier.getAsInt(), concurrencyThreshold, itemDataSize, stdOutColorFlag, TimeUnit.SECONDS.toMillis(updateIntervalSec), comment);
        this.nodeCountSupplier = nodeCountSupplier;
        this.snapshotsSupplier = snapshotsSupplier;
        this.avgPersistFlag = avgPersistFlag;
        this.sumPersistFlag = sumPersistFlag;
        this.quantileValues = quantileValues;
        this.nodeAddrs = nodeAddrs;
    }

    @Override
    public void markSucc(long bytes, long duration, long latency) {
    }

    @Override
    public void markPartSucc(long bytes, long duration, long latency) {
    }

    @Override
    public void markSucc(long count, long bytes, long[] durationValues, long[] latencyValues) {
    }

    @Override
    public void markPartSucc(long bytes, long[] durationValues, long[] latencyValues) {
    }

    @Override
    public void markFail() {
    }

    @Override
    public void markFail(long count) {
    }

    @Override
    public List<String> nodeAddrs() {
        return this.nodeAddrs;
    }

    @Override
    public int nodeCount() {
        return this.nodeCountSupplier.getAsInt();
    }

    @Override
    public List<Double> quantileValues() {
        return this.quantileValues;
    }

    @Override
    public boolean avgPersistEnabled() {
        return this.avgPersistFlag;
    }

    @Override
    public boolean sumPersistEnabled() {
        return this.sumPersistFlag;
    }

    @Override
    public void refreshLastSnapshot() {
        List<AllMetricsSnapshot> snapshots = this.snapshotsSupplier.get();
        int snapshotsCount = snapshots.size();
        if (snapshotsCount > 0) {
            TimingMetricSnapshot latSnapshot;
            TimingMetricSnapshot durSnapshot;
            ConcurrencyMetricSnapshot actualConcurrencySnapshot;
            RateMetricSnapshot bytesSnapshot;
            RateMetricSnapshot failsSnapshot;
            RateMetricSnapshot successSnapshot;
            if (snapshotsCount == 1) {
                AllMetricsSnapshot snapshot = snapshots.get(0);
                successSnapshot = snapshot.successSnapshot();
                failsSnapshot = snapshot.failsSnapshot();
                bytesSnapshot = snapshot.byteSnapshot();
                actualConcurrencySnapshot = snapshot.concurrencySnapshot();
                durSnapshot = snapshot.durationSnapshot();
                latSnapshot = snapshot.latencySnapshot();
            } else {
                ArrayList<TimingMetricSnapshot> durSnapshots = new ArrayList<TimingMetricSnapshot>();
                ArrayList<TimingMetricSnapshot> latSnapshots = new ArrayList<TimingMetricSnapshot>();
                ArrayList<ConcurrencyMetricSnapshot> conSnapshots = new ArrayList<ConcurrencyMetricSnapshot>();
                ArrayList<RateMetricSnapshot> succSnapshots = new ArrayList<RateMetricSnapshot>();
                ArrayList<RateMetricSnapshot> failSnapshots = new ArrayList<RateMetricSnapshot>();
                ArrayList<RateMetricSnapshot> byteSnapshots = new ArrayList<RateMetricSnapshot>();
                for (int i = 0; i < snapshotsCount; ++i) {
                    AllMetricsSnapshot snapshot = snapshots.get(i);
                    durSnapshots.add(snapshot.durationSnapshot());
                    latSnapshots.add(snapshot.latencySnapshot());
                    succSnapshots.add(snapshot.successSnapshot());
                    failSnapshots.add(snapshot.failsSnapshot());
                    byteSnapshots.add(snapshot.byteSnapshot());
                    conSnapshots.add(snapshot.concurrencySnapshot());
                }
                successSnapshot = RateMetricSnapshotImpl.aggregate(succSnapshots);
                failsSnapshot = RateMetricSnapshotImpl.aggregate(failSnapshots);
                bytesSnapshot = RateMetricSnapshotImpl.aggregate(byteSnapshots);
                actualConcurrencySnapshot = ConcurrencyMetricSnapshotImpl.aggregate(conSnapshots);
                durSnapshot = TimingMetricSnapshotImpl.aggregate(durSnapshots);
                latSnapshot = TimingMetricSnapshotImpl.aggregate(latSnapshots);
            }
            this.lastSnapshot = new DistributedAllMetricsSnapshotImpl(durSnapshot, latSnapshot, actualConcurrencySnapshot, failsSnapshot, successSnapshot, bytesSnapshot, this.nodeCountSupplier.getAsInt(), this.elapsedTimeMillis());
            if (this.metricsListener != null) {
                this.metricsListener.notify((DistributedAllMetricsSnapshot)this.lastSnapshot);
            }
            if (this.thresholdMetricsCtx != null) {
                this.thresholdMetricsCtx.refreshLastSnapshot();
            }
        }
    }

    @Override
    protected DistributedMetricsContextImpl<S> newThresholdMetricsContext() {
        return (DistributedMetricsContextImpl)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)((DistributedContextBuilder)new DistributedContextBuilderImpl().id(this.id).opType(this.opType)).nodeCountSupplier(this.nodeCountSupplier).concurrencyLimit(this.concurrencyLimit)).concurrencyThreshold(this.concurrencyThreshold)).itemDataSize(this.itemDataSize)).outputPeriodSec((int)TimeUnit.MILLISECONDS.toSeconds(this.outputPeriodMillis))).stdOutColorFlag(this.stdOutColorFlag)).avgPersistFlag(this.avgPersistFlag).sumPersistFlag(this.sumPersistFlag).snapshotsSupplier(this.snapshotsSupplier).quantileValues(this.quantileValues).nodeAddrs(this.nodeAddrs).build();
    }

    public final boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof MetricsContext) {
            return 0 == this.compareTo((MetricsContext)other);
        }
        return false;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.opType.name() + "-" + this.concurrencyLimit + "x" + this.nodeCount() + "@" + this.id + ")";
    }

    @Override
    public final void close() {
        super.close();
    }

    public static DistributedContextBuilder builder() {
        return new DistributedContextBuilderImpl();
    }

    private static class DistributedContextBuilderImpl
    implements DistributedContextBuilder {
        private IntSupplier nodeCountSupplier;
        private Supplier<List<AllMetricsSnapshot>> snapshotsSupplier;
        private boolean avgPersistFlag;
        private boolean sumPersistFlag;
        private List<Double> quantileValues;
        private List<String> nodeAddrs;
        private String id;
        private OpType opType;
        private int concurrencyLimit;
        private int concurrencyThreshold;
        private SizeInBytes itemDataSize;
        private boolean stdOutColorFlag;
        private int outputPeriodSec;
        private IntSupplier actualConcurrencyGauge = () -> 1;
        private String comment;

        private DistributedContextBuilderImpl() {
        }

        @Override
        public DistributedMetricsContextImpl build() {
            return new DistributedMetricsContextImpl(this.id, this.opType, this.nodeCountSupplier, this.concurrencyLimit, this.concurrencyThreshold, this.itemDataSize, this.outputPeriodSec, this.stdOutColorFlag, this.avgPersistFlag, this.sumPersistFlag, this.snapshotsSupplier, this.quantileValues, this.nodeAddrs, this.comment);
        }

        @Override
        public DistributedContextBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public DistributedContextBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public DistributedContextBuilder opType(OpType opType) {
            this.opType = opType;
            return this;
        }

        @Override
        public DistributedContextBuilder concurrencyLimit(int concurrencyLimit) {
            this.concurrencyLimit = concurrencyLimit;
            return this;
        }

        @Override
        public DistributedContextBuilder concurrencyThreshold(int concurrencyThreshold) {
            this.concurrencyThreshold = concurrencyThreshold;
            return this;
        }

        @Override
        public DistributedContextBuilder itemDataSize(SizeInBytes itemDataSize) {
            this.itemDataSize = itemDataSize;
            return this;
        }

        @Override
        public DistributedContextBuilder stdOutColorFlag(boolean stdOutColorFlag) {
            this.stdOutColorFlag = stdOutColorFlag;
            return this;
        }

        @Override
        public DistributedContextBuilder outputPeriodSec(int outputPeriodSec) {
            this.outputPeriodSec = outputPeriodSec;
            return this;
        }

        @Override
        public DistributedContextBuilder actualConcurrencyGauge(IntSupplier actualConcurrencyGauge) {
            this.actualConcurrencyGauge = actualConcurrencyGauge;
            return this;
        }

        @Override
        public DistributedContextBuilder avgPersistFlag(boolean avgPersistFlag) {
            this.avgPersistFlag = avgPersistFlag;
            return this;
        }

        @Override
        public DistributedContextBuilder sumPersistFlag(boolean sumPersistFlag) {
            this.sumPersistFlag = sumPersistFlag;
            return this;
        }

        @Override
        public DistributedContextBuilder quantileValues(List<Double> quantileValues) {
            this.quantileValues = quantileValues;
            return this;
        }

        @Override
        public DistributedContextBuilder nodeAddrs(List<String> nodeAddrs) {
            this.nodeAddrs = nodeAddrs;
            return this;
        }

        @Override
        public DistributedContextBuilder nodeCountSupplier(IntSupplier nodeCountSupplier) {
            this.nodeCountSupplier = nodeCountSupplier;
            return this;
        }

        @Override
        public DistributedContextBuilder snapshotsSupplier(Supplier<List<AllMetricsSnapshot>> snapshotsSupplier) {
            this.snapshotsSupplier = snapshotsSupplier;
            return this;
        }
    }
}

