/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.context;

import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.metrics.context.ContextBuilder;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.metrics.context.MetricsContextBase;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshotImpl;
import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshot;
import com.emc.mongoose.base.metrics.type.ConcurrencyMeterImpl;
import com.emc.mongoose.base.metrics.type.HistogramImpl;
import com.emc.mongoose.base.metrics.type.LongMeter;
import com.emc.mongoose.base.metrics.type.RateMeter;
import com.emc.mongoose.base.metrics.type.RateMeterImpl;
import com.emc.mongoose.base.metrics.type.TimingMeterImpl;
import com.emc.mongoose.base.metrics.util.ConcurrentSlidingWindowLongReservoir;
import com.github.akurilov.commons.system.SizeInBytes;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntSupplier;

public class MetricsContextImpl<S extends AllMetricsSnapshotImpl>
extends MetricsContextBase<S>
implements MetricsContext<S> {
    private final LongMeter<TimingMetricSnapshot> reqDuration;
    private final LongMeter<TimingMetricSnapshot> respLatency;
    private final LongMeter<ConcurrencyMetricSnapshot> actualConcurrency;
    private final RateMeter<RateMetricSnapshot> throughputSuccess;
    private final RateMeter<RateMetricSnapshot> throughputFail;
    private final RateMeter<RateMetricSnapshot> reqBytes;
    private volatile TimingMetricSnapshot reqDurSnapshot;
    private volatile TimingMetricSnapshot respLatSnapshot;
    private volatile ConcurrencyMetricSnapshot actualConcurrencySnapshot;
    private volatile long lastSnapshotsUpdateTs = 0L;
    private final IntSupplier actualConcurrencyGauge;
    private final ReadWriteLock timingLock = new ReentrantReadWriteLock();
    private final Lock timingLockUpdate = this.timingLock.readLock();
    private final Lock timingsUpdateLock = this.timingLock.writeLock();

    public MetricsContextImpl(String id, OpType opType, IntSupplier actualConcurrencyGauge, int concurrencyLimit, int concurrencyThreshold, SizeInBytes itemDataSize, int updateIntervalSec, boolean stdOutColorFlag, String comment) {
        super(id, opType, concurrencyLimit, 1, concurrencyThreshold, itemDataSize, stdOutColorFlag, TimeUnit.SECONDS.toMillis(updateIntervalSec), comment);
        this.respLatency = new TimingMeterImpl(new HistogramImpl(new ConcurrentSlidingWindowLongReservoir(1028)), "latency");
        this.respLatSnapshot = this.respLatency.snapshot();
        this.reqDuration = new TimingMeterImpl(new HistogramImpl(new ConcurrentSlidingWindowLongReservoir(1028)), "duration");
        this.reqDurSnapshot = this.reqDuration.snapshot();
        this.actualConcurrencyGauge = actualConcurrencyGauge;
        this.actualConcurrency = new ConcurrencyMeterImpl("concurrency");
        this.actualConcurrencySnapshot = this.actualConcurrency.snapshot();
        Clock clock = Clock.systemUTC();
        this.throughputSuccess = new RateMeterImpl(clock, "success_op");
        this.throughputFail = new RateMeterImpl(clock, "failed_op");
        this.reqBytes = new RateMeterImpl(clock, "byte");
    }

    @Override
    public final void start() {
        super.start();
        this.throughputSuccess.resetStartTime();
        this.throughputFail.resetStartTime();
        this.reqBytes.resetStartTime();
    }

    @Override
    public final void markSucc(long bytes, long duration, long latency) {
        this.throughputSuccess.update(1L);
        this.reqBytes.update(bytes);
        this.updateTimings(latency, duration);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markSucc(bytes, duration, latency);
        }
    }

    @Override
    public final void markPartSucc(long bytes, long duration, long latency) {
        this.reqBytes.update(bytes);
        this.updateTimings(latency, duration);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markPartSucc(bytes, duration, latency);
        }
    }

    @Override
    public final void markSucc(long count, long bytes, long[] durationValues, long[] latencyValues) {
        this.throughputSuccess.update(count);
        this.reqBytes.update(bytes);
        int timingsLen = Math.min(durationValues.length, latencyValues.length);
        for (int i = 0; i < timingsLen; ++i) {
            long duration = durationValues[i];
            long latency = latencyValues[i];
            this.updateTimings(latency, duration);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markSucc(count, bytes, durationValues, latencyValues);
        }
    }

    @Override
    public final void markPartSucc(long bytes, long[] durationValues, long[] latencyValues) {
        this.reqBytes.update(bytes);
        int timingsLen = Math.min(durationValues.length, latencyValues.length);
        for (int i = 0; i < timingsLen; ++i) {
            long duration = durationValues[i];
            long latency = latencyValues[i];
            this.updateTimings(latency, duration);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markPartSucc(bytes, durationValues, latencyValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimings(long latencyMicros, long durationMicros) {
        if (latencyMicros > 0L && durationMicros > latencyMicros) {
            this.timingLockUpdate.lock();
            try {
                this.reqDuration.update(durationMicros);
                this.respLatency.update(latencyMicros);
            }
            finally {
                this.timingLockUpdate.unlock();
            }
        }
    }

    @Override
    public final void markFail() {
        this.throughputFail.update(1L);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markFail();
        }
    }

    @Override
    public final void markFail(long count) {
        this.throughputFail.update(count);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markFail(count);
        }
    }

    @Override
    public final boolean avgPersistEnabled() {
        return false;
    }

    @Override
    public final boolean sumPersistEnabled() {
        return false;
    }

    @Override
    public void refreshLastSnapshot() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastSnapshotsUpdateTs > 100L) {
            this.lastSnapshotsUpdateTs = currentTimeMillis;
            this.updateTimings();
            this.actualConcurrency.update(this.actualConcurrencyGauge.getAsInt());
            this.actualConcurrencySnapshot = this.actualConcurrency.snapshot();
        }
        this.lastSnapshot = new AllMetricsSnapshotImpl(this.reqDurSnapshot, this.respLatSnapshot, this.actualConcurrencySnapshot, (RateMetricSnapshot)this.throughputFail.snapshot(), (RateMetricSnapshot)this.throughputSuccess.snapshot(), (RateMetricSnapshot)this.reqBytes.snapshot(), this.elapsedTimeMillis());
        super.refreshLastSnapshot();
    }

    private void updateTimings() {
        if (this.timingsUpdateLock.tryLock()) {
            try {
                this.reqDurSnapshot = this.reqDuration.snapshot();
                this.respLatSnapshot = this.respLatency.snapshot();
            }
            finally {
                this.timingsUpdateLock.unlock();
            }
        }
    }

    @Override
    protected MetricsContextImpl<S> newThresholdMetricsContext() {
        return new ContextBuilderImpl().id(this.id()).opType(this.opType).actualConcurrencyGauge(this.actualConcurrencyGauge).concurrencyLimit(this.concurrencyLimit).concurrencyThreshold(0).itemDataSize(this.itemDataSize).outputPeriodSec((int)TimeUnit.MILLISECONDS.toSeconds(this.outputPeriodMillis)).stdOutColorFlag(this.stdOutColorFlag).build();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof MetricsContextImpl) {
            return 0 == this.compareTo((MetricsContextImpl)other);
        }
        return false;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.opType.name() + "-" + this.concurrencyLimit + "x1@" + this.id + ")";
    }

    @Override
    public final void close() {
        super.close();
    }

    public static ContextBuilder builder() {
        return new ContextBuilderImpl();
    }

    private static class ContextBuilderImpl
    implements ContextBuilder<ContextBuilder, MetricsContextImpl> {
        private IntSupplier actualConcurrencyGauge;
        private String id;
        private OpType opType;
        private int concurrencyLimit;
        private int concurrencyThreshold;
        private SizeInBytes itemDataSize;
        private boolean stdOutColorFlag;
        private int outputPeriodSec;
        private String comment;

        private ContextBuilderImpl() {
        }

        @Override
        public MetricsContextImpl build() {
            return new MetricsContextImpl(this.id, this.opType, this.actualConcurrencyGauge, this.concurrencyLimit, this.concurrencyThreshold, this.itemDataSize, this.outputPeriodSec, this.stdOutColorFlag, this.comment);
        }

        @Override
        public ContextBuilderImpl id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ContextBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public ContextBuilderImpl opType(OpType opType) {
            this.opType = opType;
            return this;
        }

        @Override
        public ContextBuilderImpl concurrencyLimit(int concurrencyLimit) {
            this.concurrencyLimit = concurrencyLimit;
            return this;
        }

        @Override
        public ContextBuilderImpl concurrencyThreshold(int concurrencyThreshold) {
            this.concurrencyThreshold = concurrencyThreshold;
            return this;
        }

        @Override
        public ContextBuilderImpl itemDataSize(SizeInBytes itemDataSize) {
            this.itemDataSize = itemDataSize;
            return this;
        }

        @Override
        public ContextBuilderImpl stdOutColorFlag(boolean stdOutColorFlag) {
            this.stdOutColorFlag = stdOutColorFlag;
            return this;
        }

        @Override
        public ContextBuilderImpl outputPeriodSec(int outputPeriodSec) {
            this.outputPeriodSec = outputPeriodSec;
            return this;
        }

        @Override
        public ContextBuilderImpl actualConcurrencyGauge(IntSupplier actualConcurrencyGauge) {
            this.actualConcurrencyGauge = actualConcurrencyGauge;
            return this;
        }
    }
}

