/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.snapshot;

import com.emc.mongoose.base.metrics.snapshot.NamedCountMetricSnapshotImpl;
import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshot;
import java.util.List;

public class RateMetricSnapshotImpl
extends NamedCountMetricSnapshotImpl
implements RateMetricSnapshot {
    private final double last;
    private final double mean;
    private final long elapsedTimeMillis;

    public RateMetricSnapshotImpl(double last, double mean, String metricName, long count, long elapsedTimeMillis) {
        super(metricName, count);
        this.last = last;
        this.mean = mean;
        this.elapsedTimeMillis = elapsedTimeMillis;
    }

    public static RateMetricSnapshot aggregate(List<RateMetricSnapshot> snapshots) {
        int snapshotsCount = snapshots.size();
        if (snapshotsCount == 1) {
            return snapshots.get(0);
        }
        double lastRateSum = 0.0;
        double meanRateSum = 0.0;
        long countSum = 0L;
        long maxElapsedTimeMillis = Long.MIN_VALUE;
        for (int i = 0; i < snapshotsCount; ++i) {
            RateMetricSnapshot nextSnapshot = snapshots.get(i);
            countSum += nextSnapshot.count();
            lastRateSum += nextSnapshot.last();
            meanRateSum += nextSnapshot.mean();
            if (nextSnapshot.elapsedTimeMillis() <= maxElapsedTimeMillis) continue;
            maxElapsedTimeMillis = nextSnapshot.elapsedTimeMillis();
        }
        return new RateMetricSnapshotImpl(lastRateSum, meanRateSum, snapshots.get(0).name(), countSum, maxElapsedTimeMillis);
    }

    @Override
    public final double last() {
        return this.last;
    }

    @Override
    public final long elapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    @Override
    public final double mean() {
        return this.mean;
    }
}

