/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.type;

import com.emc.mongoose.base.metrics.type.LoadAverage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public final class EWMA
implements LoadAverage {
    private volatile boolean initialized = false;
    private volatile double rate = 0.0;
    private final LongAdder uncounted = new LongAdder();
    private final double alpha;
    private final double interval;

    public EWMA(double alpha, long interval, TimeUnit intervalUnit) {
        this.interval = intervalUnit.toNanos(interval);
        this.alpha = alpha;
    }

    @Override
    public final void update(long n) {
        this.uncounted.add(n);
    }

    @Override
    public final void tick() {
        long count = this.uncounted.sumThenReset();
        double instantRate = (double)count / this.interval;
        if (this.initialized) {
            double oldRate = this.rate;
            this.rate = oldRate + this.alpha * (instantRate - oldRate);
        } else {
            this.rate = instantRate;
            this.initialized = true;
        }
    }

    @Override
    public final double rate(TimeUnit rateUnit) {
        return this.rate * (double)rateUnit.toNanos(1L);
    }
}

