/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.util;

import com.emc.mongoose.base.metrics.util.LongReservoir;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentSlidingWindowLongReservoir
implements LongReservoir {
    private static final int DEFAULT_SIZE = 1028;
    private final long[] measurements;
    private final AtomicLong count;

    public ConcurrentSlidingWindowLongReservoir(int size) {
        this.measurements = new long[size];
        this.count = new AtomicLong();
    }

    public ConcurrentSlidingWindowLongReservoir() {
        this(1028);
    }

    @Override
    public int size() {
        return (int)Math.min(this.count.get(), (long)this.measurements.length);
    }

    @Override
    public void update(long value) {
        this.measurements[(int)(this.count.getAndIncrement() % (long)this.measurements.length)] = value;
    }

    @Override
    public long[] snapshot() {
        long countSnapshot = this.count.get();
        if (countSnapshot < (long)this.measurements.length) {
            return Arrays.copyOf(this.measurements, (int)countSnapshot);
        }
        return (long[])this.measurements.clone();
    }
}

