/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.concurrent;

import com.github.akurilov.commons.concurrent.AsyncRunnable;
import com.github.akurilov.commons.concurrent.AsyncRunnableBase;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DaemonBase
extends AsyncRunnableBase {
    private static final Logger LOG = Logger.getLogger(DaemonBase.class.getName());
    private static final Queue<AsyncRunnable> REGISTRY = new ConcurrentLinkedQueue<AsyncRunnable>();

    protected DaemonBase() {
        REGISTRY.add(this);
    }

    @Override
    public final void close() throws IOException {
        REGISTRY.remove(this);
        super.close();
    }

    public static void closeAll() {
        while (!REGISTRY.isEmpty()) {
            try {
                REGISTRY.peek().close();
            }
            catch (Throwable cause) {
                LOG.log(Level.WARNING, "Failed to close the daemon instance", cause);
            }
        }
    }
}

