/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io;

import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class BinInput<T>
implements Input<T> {
    protected ObjectInputStream itemsSrc;
    protected T[] srcBuff = null;
    protected int srcBuffPos = 0;
    private T lastItem = null;

    public BinInput(ObjectInputStream itemsSrc) {
        this.itemsSrc = itemsSrc;
    }

    public void setItemsSrc(ObjectInputStream itemsSrc) {
        this.itemsSrc = itemsSrc;
    }

    @Override
    public final T get() {
        if (this.srcBuff != null && this.srcBuffPos < this.srcBuff.length) {
            return this.srcBuff[this.srcBuffPos++];
        }
        try {
            Object o = this.itemsSrc.readUnshared();
            if (o instanceof Object[]) {
                this.srcBuff = (Object[])o;
                this.srcBuffPos = 0;
                return this.get();
            }
            return (T)o;
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            Exceptions.throwUnchecked(e);
            return null;
        }
    }

    @Override
    public final int get(List<T> dstBuff, int dstCountLimit) {
        if (this.srcBuff != null) {
            int srcCountLimit = this.srcBuff.length - this.srcBuffPos;
            if (dstCountLimit < srcCountLimit) {
                for (int i = this.srcBuffPos; i < this.srcBuffPos + dstCountLimit; ++i) {
                    dstBuff.add(this.srcBuff[i]);
                }
                this.srcBuffPos += dstCountLimit;
                return dstCountLimit;
            }
            for (int i = this.srcBuffPos; i < this.srcBuffPos + srcCountLimit; ++i) {
                dstBuff.add(this.srcBuff[i]);
            }
            this.srcBuff = null;
            return srcCountLimit;
        }
        try {
            Object o = this.itemsSrc.readUnshared();
            if (o instanceof Object[]) {
                this.srcBuff = (Object[])o;
                this.srcBuffPos = 0;
                return this.get(dstBuff, dstCountLimit);
            }
            if (dstCountLimit > 0) {
                dstBuff.add(o);
                return 1;
            }
            return 0;
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            Exceptions.throwUnchecked(e);
            return 0;
        }
    }

    @Override
    public void reset() {
        try {
            this.itemsSrc.reset();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        this.srcBuff = null;
    }

    @Override
    public long skip(long itemsCount) {
        try {
            long i = 0L;
            while (i < itemsCount) {
                Object o = this.itemsSrc.readUnshared();
                if (o instanceof Object[]) {
                    this.srcBuff = (Object[])o;
                    if ((long)this.srcBuff.length > itemsCount - i) {
                        this.srcBuffPos = (int)(itemsCount - i);
                        break;
                    }
                    i += (long)this.srcBuff.length;
                    this.srcBuff = null;
                    continue;
                }
                if (o.equals(this.lastItem)) break;
                ++i;
            }
            return i;
        }
        catch (IOException | ClassNotFoundException e) {
            Exceptions.throwUnchecked(e);
            return 0L;
        }
    }

    @Override
    public void close() {
        try {
            this.itemsSrc.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        this.srcBuff = null;
    }

    public String toString() {
        return "binInput<" + this.itemsSrc.toString() + ">";
    }
}

