/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io;

import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;

public abstract class BinOutput<T>
implements Output<T> {
    protected final ObjectOutputStream output;

    protected BinOutput(ObjectOutputStream output) {
        this.output = output;
    }

    @Override
    public boolean put(T item) {
        try {
            this.output.writeUnshared(item);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        return true;
    }

    @Override
    public int put(List<T> buffer, int from, int to) {
        try {
            this.output.writeUnshared(buffer.subList(from, to).toArray(new Object[to - from]));
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        return to - from;
    }

    @Override
    public final int put(List<T> items) {
        return this.put(items, 0, items.size());
    }

    @Override
    public void close() {
        try {
            this.output.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    public String toString() {
        return "binOutput<" + this.output + ">";
    }
}

