/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io;

import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public abstract class TextStreamOutput
implements Output<String> {
    private static final ThreadLocal<StringBuilder> THRLOC_STRB = ThreadLocal.withInitial(StringBuilder::new);
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected final BufferedWriter writer;

    public TextStreamOutput(OutputStream out) {
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
    }

    public TextStreamOutput(OutputStream out, int buffSize) {
        this.writer = new BufferedWriter(new OutputStreamWriter(out), buffSize);
    }

    @Override
    public boolean put(String line) {
        try {
            this.writer.write(line + LINE_SEP);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        return true;
    }

    @Override
    public int put(List<String> lines, int from, int to) {
        StringBuilder strb = THRLOC_STRB.get();
        strb.setLength(0);
        for (int i = from; i < to; ++i) {
            strb.append(lines.get(i));
            strb.append(LINE_SEP);
        }
        try {
            this.writer.write(strb.toString());
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        return to - from;
    }

    @Override
    public int put(List<String> lines) {
        StringBuilder strb = THRLOC_STRB.get();
        strb.setLength(0);
        for (String line : lines) {
            strb.append(line);
            strb.append(LINE_SEP);
        }
        try {
            this.writer.write(strb.toString());
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        return lines.size();
    }

    @Override
    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }
}

