/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.collection.ListInput;
import java.util.List;

public class CircularListInput<T>
extends ListInput<T> {
    public CircularListInput(List<T> dataItems) {
        super(dataItems);
    }

    @Override
    public T get() {
        if (this.i >= this.size) {
            this.reset();
        }
        return (T)this.items.get(this.i++);
    }

    @Override
    public int get(List<T> buffer, int maxCount) {
        int n;
        for (n = 0; n < maxCount; n += super.get(buffer, Math.min(this.size - this.i, maxCount - n))) {
            if (this.i < this.size) continue;
            this.reset();
        }
        return n;
    }

    @Override
    public String toString() {
        return "circularListInput<" + this.items.hashCode() + ">";
    }
}

