/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.collection.CircularListInput;
import com.github.akurilov.commons.io.collection.ListOutput;
import java.util.ArrayList;
import java.util.List;

public class CircularListOutput<T>
extends ListOutput<T> {
    protected int capacity;
    protected int i = 0;

    public CircularListOutput(List<T> itemList, int capacity) throws IllegalArgumentException {
        super(itemList);
        if (ArrayList.class.isInstance(itemList)) {
            ((ArrayList)ArrayList.class.cast(itemList)).ensureCapacity(capacity);
        }
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity should be > 0");
        }
        this.capacity = capacity;
    }

    @Override
    public boolean put(T item) {
        if (this.i >= this.capacity) {
            this.i = 0;
        }
        return super.put(item);
    }

    @Override
    public int put(List<T> buffer, int from, int to) {
        int n = to - from;
        if (buffer.size() > n) {
            return this.put(buffer.subList(from, to), 0, n);
        }
        n = buffer.size();
        if (n < this.capacity) {
            int limit = this.capacity - this.items.size();
            if (n > limit) {
                this.items.removeAll(this.items.subList(0, n - limit));
            }
            for (int j = from; j < to; ++j) {
                this.items.add(buffer.get(j));
            }
        } else {
            this.items.clear();
            for (T item : buffer.subList(n - this.capacity, n)) {
                this.items.add(item);
            }
        }
        return n;
    }

    @Override
    public CircularListInput<T> getInput() {
        return new CircularListInput(new ArrayList(this.items));
    }

    @Override
    public final String toString() {
        return "circularListOutput<" + this.items.hashCode() + ">";
    }
}

