/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.EOFException;
import java.util.List;

public class ListInput<T>
implements Input<T> {
    protected final List<T> items;
    protected int size;
    protected int i = 0;

    public ListInput(List<T> items) {
        this.items = items;
        this.size = items == null ? 0 : items.size();
    }

    @Override
    public T get() {
        if (this.i < this.size) {
            return this.items.get(this.i++);
        }
        Exceptions.throwUnchecked(new EOFException());
        return null;
    }

    @Override
    public int get(List<T> buffer, int maxCount) {
        int n = this.size - this.i;
        if (n > 0) {
            n = Math.min(n, maxCount);
            for (T item : this.items.subList(this.i, this.i + n)) {
                buffer.add(item);
            }
        } else {
            Exceptions.throwUnchecked(new EOFException());
        }
        this.i += n;
        return n;
    }

    @Override
    public void reset() {
        this.i = 0;
    }

    @Override
    public long skip(long itemsCount) {
        int remainingCount = this.size - this.i;
        if (itemsCount > (long)remainingCount) {
            this.i = 0;
            return remainingCount;
        }
        this.i += (int)itemsCount;
        return itemsCount;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "listInput<" + this.items.hashCode() + ">";
    }
}

