/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.io.collection.ListInput;
import java.util.List;

public class ListOutput<T>
implements Output<T> {
    protected final List<T> items;

    public ListOutput(List<T> items) {
        this.items = items;
    }

    @Override
    public boolean put(T item) {
        return this.items.add(item);
    }

    @Override
    public int put(List<T> buffer, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.items.add(buffer.get(i));
        }
        return to - from;
    }

    @Override
    public final int put(List<T> items) {
        return this.put(items, 0, items.size());
    }

    @Override
    public ListInput<T> getInput() {
        return new ListInput<T>(this.items);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "listOutput<" + this.items.hashCode() + ">";
    }
}

