/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.util;

import com.github.akurilov.commons.io.util.BufferedByteChannelBase;
import com.github.akurilov.commons.io.util.BufferedWritableByteChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class OutputStreamWrapperChannel
extends BufferedByteChannelBase
implements BufferedWritableByteChannel {
    private OutputStream out = null;
    private static final ThreadLocal<OutputStreamWrapperChannel[]> REUSABLE_OUTPUT_CHANNELS = ThreadLocal.withInitial(() -> {
        int count = (int)(Math.log(1.6777216E7) / Math.log(2.0) + 1.0);
        return new OutputStreamWrapperChannel[count];
    });

    public OutputStreamWrapperChannel(OutputStream out, int buffSize) {
        super(buffSize);
        this.out = out;
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        int n = Math.min(this.bb.length, src.remaining());
        if (n > 0) {
            src.get(this.bb, 0, n);
            this.out.write(this.bb, 0, n);
        }
        return n;
    }

    public static BufferedWritableByteChannel getThreadLocalInstance(OutputStream out, long remainingSize) throws IllegalStateException {
        if (remainingSize < 0L) {
            throw new IllegalArgumentException("Requested negative size: " + remainingSize);
        }
        OutputStreamWrapperChannel[] threadLocalReusableChannels = REUSABLE_OUTPUT_CHANNELS.get();
        long currBuffSize = Long.highestOneBit(remainingSize);
        if (currBuffSize > 0x1000000L) {
            currBuffSize = 0x1000000L;
        } else if (currBuffSize < 0x1000000L) {
            if (currBuffSize < 1L) {
                currBuffSize = 1L;
            } else if (currBuffSize < remainingSize) {
                currBuffSize <<= 1;
            }
        }
        int i = Long.numberOfTrailingZeros(currBuffSize);
        OutputStreamWrapperChannel chan = threadLocalReusableChannels[i];
        if (chan == null) {
            threadLocalReusableChannels[i] = chan = new OutputStreamWrapperChannel(out, (int)currBuffSize);
        }
        chan.out = out;
        return chan;
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.out = null;
    }
}

