/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.confuse.impl;

import com.github.akurilov.commons.collection.TreeUtil;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.exceptions.InvalidValuePathException;
import com.github.akurilov.confuse.exceptions.InvalidValueTypeException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class BasicConfig
implements Config {
    private final String pathSep;
    private final Map<String, Object> schema;
    private final Map<String, Object> node;

    public BasicConfig(String pathSep, Map<String, Object> schema) throws IllegalArgumentException {
        this(pathSep, schema, Collections.emptyMap());
    }

    public BasicConfig(String pathSep, Map<String, Object> schema, Map<String, Object> node) throws InvalidValuePathException, InvalidValueTypeException, IllegalArgumentException {
        if (pathSep == null || pathSep.isEmpty()) {
            throw new IllegalArgumentException("Path separator should not be null/empty");
        }
        this.pathSep = pathSep;
        this.schema = TreeUtil.copyTree(schema);
        if (node == null || node.size() == 0) {
            this.node = new HashMap<String, Object>();
        } else {
            this.node = new HashMap<String, Object>(node.size());
            node.forEach(this::putBranch);
        }
    }

    private void putBranch(String key, Object val) throws InvalidValuePathException, InvalidValueTypeException {
        Object schemaVal = this.schema.get(key);
        if (schemaVal instanceof Map) {
            try {
                this.putBranch(key, (Map)schemaVal, val);
            }
            catch (InvalidValuePathException e) {
                throw new InvalidValuePathException(key + this.pathSep + e.path());
            }
            catch (InvalidValueTypeException e) {
                throw new InvalidValueTypeException(key + this.pathSep + e.path(), e.expectedType(), e.actualType());
            }
        } else if (schemaVal instanceof Class) {
            try {
                this.putLeaf(key, (Class)schemaVal, val);
            }
            catch (InvalidValuePathException e) {
                throw new InvalidValuePathException(key + this.pathSep + e.path());
            }
            catch (InvalidValueTypeException e) {
                throw new InvalidValueTypeException(key + this.pathSep + e.path(), e.expectedType(), e.actualType());
            }
        } else {
            if (schemaVal == null) {
                throw new InvalidValuePathException(key);
            }
            throw new InvalidValueTypeException(key, schemaVal.getClass(), val == null ? null : val.getClass());
        }
    }

    private void putBranch(String key, Map<String, Object> schemaBranch, Object val) throws InvalidValuePathException, InvalidValueTypeException {
        BasicConfig branch;
        if (val instanceof Config) {
            branch = new BasicConfig((Config)val);
        } else if (val instanceof Map) {
            branch = new BasicConfig(this.pathSep, schemaBranch, (Map)val);
        } else {
            throw new InvalidValuePathException(key);
        }
        this.node.put(key, branch);
    }

    protected void putLeaf(String key, Class<?> expectedValType, Object val) throws InvalidValuePathException, InvalidValueTypeException {
        if (val == null) {
            if (expectedValType.isPrimitive()) {
                throw new InvalidValueTypeException(key, expectedValType, null);
            }
            this.node.put(key, null);
        } else {
            Class<?> actualValType = val.getClass();
            if (TypeUtil.typeEquals(expectedValType, actualValType)) {
                this.node.put(key, val);
            } else {
                try {
                    this.node.put(key, TypeUtil.typeConvert(val, expectedValType));
                }
                catch (ClassCastException e) {
                    throw new InvalidValueTypeException(key, expectedValType, actualValType);
                }
            }
        }
    }

    public BasicConfig(Config other) throws InvalidValuePathException, InvalidValueTypeException, IllegalArgumentException {
        this(other.pathSep(), other.schema(), other.mapVal(""));
    }

    @Override
    public final String pathSep() {
        return this.pathSep;
    }

    @Override
    public final Map<String, Object> schema() {
        return this.schema;
    }

    @Override
    public Object val(String path) throws InvalidValuePathException, NoSuchElementException {
        if (path == null || path.isEmpty()) {
            return this.node;
        }
        int sepPos = path.indexOf(this.pathSep);
        if (sepPos == 0 || sepPos == path.length() - 1) {
            throw new InvalidValuePathException(path);
        }
        if (sepPos > 0) {
            String key = path.substring(0, sepPos);
            String subPath = path.substring(sepPos + 1);
            Object child = this.node.get(key);
            if (child instanceof Config) {
                try {
                    return ((Config)child).val(subPath);
                }
                catch (InvalidValuePathException e) {
                    throw new InvalidValuePathException(key + this.pathSep + e.path());
                }
                catch (NoSuchElementException e) {
                    throw new NoSuchElementException(key + this.pathSep + e.getMessage());
                }
            }
            throw new NoSuchElementException(path);
        }
        return this.node.get(path);
    }

    @Override
    public void val(String path, Object val) throws InvalidValuePathException, InvalidValueTypeException {
        int sepPos = path.indexOf(this.pathSep);
        if (sepPos == 0 || sepPos == path.length() - 1) {
            throw new InvalidValuePathException(path);
        }
        if (sepPos > 0) {
            String key = path.substring(0, sepPos);
            String childPath = path.substring(sepPos + 1);
            this.val(key, childPath, val);
        } else {
            this.leafVal(path, val);
        }
    }

    protected void val(String key, String childPath, Object val) throws InvalidValuePathException, InvalidValueTypeException {
        Object schemaVal = this.schema.get(key);
        if (schemaVal instanceof Map) {
            Object child = this.node.get(key);
            try {
                Config childConfig;
                if (child instanceof Config) {
                    childConfig = (Config)child;
                } else {
                    childConfig = new BasicConfig(this.pathSep, (Map)schemaVal);
                    this.node.put(key, childConfig);
                }
                childConfig.val(childPath, val);
            }
            catch (InvalidValuePathException e) {
                throw new InvalidValuePathException(key + this.pathSep + e.path());
            }
            catch (InvalidValueTypeException e) {
                throw new InvalidValueTypeException(key + this.pathSep + e.path(), e.expectedType(), e.actualType());
            }
        } else if (Map.class.equals(schemaVal)) {
            Map<String, Object> mapVal;
            Object prevNodeVal = this.node.get(key);
            if (prevNodeVal == null) {
                mapVal = new HashMap<String, Object>();
            } else if (prevNodeVal instanceof Map) {
                mapVal = (Map)prevNodeVal;
            } else {
                throw new InvalidValueTypeException(key, Map.class, prevNodeVal.getClass());
            }
            mapVal.put(childPath, val);
        } else {
            throw new InvalidValuePathException(key);
        }
    }

    protected void leafVal(String key, Object val) throws InvalidValuePathException, InvalidValueTypeException {
        Object schemaVal = this.schema.get(key);
        if (!(schemaVal instanceof Class)) {
            throw new InvalidValuePathException(key);
        }
        this.putLeaf(key, (Class)schemaVal, val);
    }

    @Override
    public String stringVal(String path) throws InvalidValuePathException, NoSuchElementException {
        return (String)this.val(path);
    }

    @Override
    public boolean boolVal(String path) throws InvalidValuePathException, InvalidValueTypeException, NoSuchElementException {
        Object v = this.val(path);
        if (v == null) {
            throw new InvalidValueTypeException(path, Boolean.TYPE, null);
        }
        if (v instanceof String) {
            return Boolean.parseBoolean((String)v);
        }
        try {
            return (Boolean)v;
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Boolean.TYPE, v.getClass());
        }
    }

    @Override
    public char charVal(String path) throws InvalidValueTypeException, NoSuchElementException {
        Object v = this.val(path);
        if (v == null) {
            throw new InvalidValueTypeException(path, Character.TYPE, null);
        }
        try {
            return ((Character)v).charValue();
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Character.TYPE, v.getClass());
        }
    }

    @Override
    public byte byteVal(String path) throws InvalidValueTypeException, NoSuchElementException {
        Object v = this.val(path);
        if (v == null) {
            throw new InvalidValueTypeException(path, Byte.TYPE, null);
        }
        if (v instanceof String) {
            return Byte.parseByte((String)v);
        }
        try {
            return (Byte)v;
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Byte.TYPE, v.getClass());
        }
    }

    @Override
    public short shortVal(String path) throws InvalidValueTypeException, NoSuchElementException, NumberFormatException {
        Object v = this.val(path);
        if (v == null) {
            throw new InvalidValueTypeException(path, Short.TYPE, null);
        }
        if (v instanceof String) {
            return Short.parseShort((String)v);
        }
        try {
            return (Short)v;
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Short.TYPE, v.getClass());
        }
    }

    @Override
    public int intVal(String path) throws InvalidValuePathException, NoSuchElementException, NumberFormatException {
        Object v = this.val(path);
        if (v == null) {
            throw new InvalidValueTypeException(path, Integer.TYPE, null);
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        if (v instanceof Short) {
            return ((Short)v).shortValue();
        }
        try {
            return (Integer)v;
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Integer.TYPE, v.getClass());
        }
    }

    @Override
    public long longVal(String path) throws InvalidValuePathException, NoSuchElementException, NumberFormatException {
        Object v = this.val(path);
        if (v == null) {
            throw new InvalidValueTypeException(path, Long.TYPE, null);
        }
        if (v instanceof String) {
            return Long.parseLong((String)v);
        }
        if (v instanceof Short) {
            return ((Short)v).shortValue();
        }
        if (v instanceof Integer) {
            return ((Integer)v).intValue();
        }
        try {
            return (Long)v;
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Long.TYPE, v.getClass());
        }
    }

    @Override
    public float floatVal(String path) throws InvalidValueTypeException, NoSuchElementException, NumberFormatException {
        Object v = this.val(path);
        if (v == null) {
            throw new InvalidValueTypeException(path, Float.TYPE, null);
        }
        if (v instanceof String) {
            return Float.parseFloat((String)v);
        }
        try {
            return ((Float)v).floatValue();
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Float.TYPE, v.getClass());
        }
    }

    @Override
    public double doubleVal(String path) throws InvalidValuePathException, NoSuchElementException, NumberFormatException {
        Object v = this.val(path);
        if (v == null) {
            throw new InvalidValueTypeException(path, Double.TYPE, null);
        }
        if (v instanceof String) {
            return Double.parseDouble((String)v);
        }
        if (v instanceof Float) {
            return ((Float)v).floatValue();
        }
        try {
            return (Double)v;
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Double.TYPE, v.getClass());
        }
    }

    @Override
    public <V> Map<String, V> mapVal(String path) throws InvalidValuePathException, NoSuchElementException {
        Object v = this.val(path);
        if (v instanceof Config) {
            return ((Config)v).mapVal("");
        }
        try {
            return (Map)v;
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, Map.class, v.getClass());
        }
    }

    @Override
    public <E> List<E> listVal(String path) throws InvalidValuePathException, NoSuchElementException {
        Object v = this.val(path);
        try {
            return (List)v;
        }
        catch (ClassCastException e) {
            throw new InvalidValueTypeException(path, List.class, v.getClass());
        }
    }

    @Override
    public Config configVal(String path) throws InvalidValuePathException, InvalidValueTypeException {
        return (Config)this.val(path);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BasicConfig)) {
            return false;
        }
        BasicConfig other = (BasicConfig)o;
        for (String key : this.node.keySet()) {
            Object val = this.node.get(key);
            if (!(val == null ? other.node.get(key) != null : !val.equals(other.node.get(key)))) continue;
            return false;
        }
        return true;
    }
}

