/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.confuse.io.yaml;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.akurilov.confuse.SchemaProvider;
import com.github.akurilov.confuse.io.yaml.TypeNames;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class YamlSchemaProviderBase
implements SchemaProvider {
    @Override
    public Map<String, Object> schema() throws IOException {
        Map rawSchema;
        ObjectMapper m = new YAMLMapper().enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY).enable(SerializationFeature.INDENT_OUTPUT);
        try (InputStream input = this.schemaInputStream();){
            rawSchema = (Map)m.readValue(input, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return this.deserializeTypes(rawSchema);
    }

    private Map<String, Object> deserializeTypes(Map<String, Object> rawNode) throws ClassCastException {
        HashMap<String, Object> node = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : rawNode.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof String) {
                Class resolvedType = TypeNames.MAP.get(val);
                if (null == resolvedType) {
                    throw new IllegalArgumentException("The type \"" + val + "\" couldn't be resolved");
                }
                node.put(key, resolvedType);
                continue;
            }
            node.put(key, this.deserializeTypes((Map)val));
        }
        return node;
    }

    protected abstract InputStream schemaInputStream() throws IOException;
}

