/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.fiber4j;

import com.github.akurilov.commons.concurrent.ContextAwareThreadFactory;
import com.github.akurilov.fiber4j.Fiber;
import com.github.akurilov.fiber4j.FibersExecutorTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class FibersExecutor {
    private static final Logger LOG = Logger.getLogger(FibersExecutor.class.getName());
    private final ThreadPoolExecutor executor;
    private final boolean backgroundFlag;
    private final List<FibersExecutorTask> workers = new ArrayList<FibersExecutorTask>();
    private final Queue<Fiber> fibers = new ConcurrentLinkedQueue<Fiber>();

    public FibersExecutor() {
        this(true);
    }

    public FibersExecutor(boolean backgroundFlag) {
        int svcThreadCount = Runtime.getRuntime().availableProcessors();
        this.executor = new ThreadPoolExecutor(svcThreadCount, svcThreadCount, 0L, TimeUnit.DAYS, new ArrayBlockingQueue<Runnable>(1), new ContextAwareThreadFactory("fibers-executor-", true, null));
        this.backgroundFlag = backgroundFlag;
        for (int i = 0; i < svcThreadCount; ++i) {
            FibersExecutorTask svcWorkerTask = new FibersExecutorTask(this.fibers, backgroundFlag);
            this.executor.submit(svcWorkerTask);
            this.workers.add(svcWorkerTask);
            svcWorkerTask.start();
        }
    }

    public void start(Fiber fiber) {
        this.fibers.add(fiber);
    }

    public void stop(Fiber fiber) {
        this.fibers.remove(fiber);
    }

    public void setThreadCount(int threadCount) {
        block6: {
            int oldThreadCount;
            int newThreadCount = threadCount > 0 ? threadCount : Runtime.getRuntime().availableProcessors();
            if (newThreadCount == (oldThreadCount = this.executor.getCorePoolSize())) break block6;
            this.executor.setCorePoolSize(newThreadCount);
            this.executor.setMaximumPoolSize(newThreadCount);
            if (newThreadCount > oldThreadCount) {
                for (int i = oldThreadCount; i < newThreadCount; ++i) {
                    FibersExecutorTask execTask = new FibersExecutorTask(this.fibers, this.backgroundFlag);
                    this.executor.submit(execTask);
                    this.workers.add(execTask);
                    execTask.start();
                }
            } else {
                try {
                    for (int i = oldThreadCount - 1; i >= newThreadCount; --i) {
                        this.workers.remove(i).close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

