/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.util;

import java.beans.FeatureDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootPropertyResolver
extends ELResolver {
    private final Map<String, Object> map = Collections.synchronizedMap(new HashMap());
    private final boolean readOnly;

    public RootPropertyResolver() {
        this(false);
    }

    public RootPropertyResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private boolean isResolvable(Object base) {
        return base == null;
    }

    private boolean resolve(ELContext context, Object base, Object property) {
        context.setPropertyResolved(this.isResolvable(base) && property instanceof String);
        return context.isPropertyResolved();
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.isResolvable(context) ? String.class : null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        return this.resolve(context, base, property) ? Object.class : null;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (this.resolve(context, base, property)) {
            if (!this.isProperty((String)property)) {
                throw new PropertyNotFoundException("Cannot find property " + property);
            }
            return this.getProperty((String)property);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return this.resolve(context, base, property) ? this.readOnly : false;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws PropertyNotWritableException {
        if (this.resolve(context, base, property)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("Resolver is read only!");
            }
            this.setProperty((String)property, value);
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (this.resolve(context, base, method)) {
            throw new NullPointerException("Cannot invoke method " + method + " on null");
        }
        return null;
    }

    public Object getProperty(String property) {
        return this.map.get(property);
    }

    public void setProperty(String property, Object value) {
        this.map.put(property, value);
    }

    public boolean isProperty(String property) {
        return this.map.containsKey(property);
    }

    public Iterable<String> properties() {
        return this.map.keySet();
    }
}

