/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.concurrent.ServiceTaskExecutor;
import com.emc.mongoose.base.config.AliasingUtil;
import com.emc.mongoose.base.config.CliArgUtil;
import com.emc.mongoose.base.config.ConfigUtil;
import com.emc.mongoose.base.config.IllegalArgumentNameException;
import com.emc.mongoose.base.control.AddCorsHeadersRule;
import com.emc.mongoose.base.control.ConfigServlet;
import com.emc.mongoose.base.control.logs.LogServlet;
import com.emc.mongoose.base.control.run.RunImpl;
import com.emc.mongoose.base.control.run.RunServlet;
import com.emc.mongoose.base.env.CoreResourcesToInstall;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.load.step.ScenarioUtil;
import com.emc.mongoose.base.load.step.service.LoadStepManagerServiceImpl;
import com.emc.mongoose.base.load.step.service.file.FileManagerServiceImpl;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.metrics.MetricsManagerImpl;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.SchemaProvider;
import com.github.akurilov.confuse.exceptions.InvalidValuePathException;
import com.github.akurilov.confuse.exceptions.InvalidValueTypeException;
import io.prometheus.client.exporter.MetricsServlet;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.servlet.MultipartConfigElement;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public final class Main {
    public static void main(String ... args) {
        CoreResourcesToInstall coreResources = new CoreResourcesToInstall();
        Path appHomePath = coreResources.appHomePath();
        String initialStepId = "none-" + LogUtil.getDateTimeStamp();
        LogUtil.init(appHomePath.toString(), initialStepId);
        try {
            coreResources.install(appHomePath);
            Config defaultConfig = Main.loadDefaultConfig(appHomePath);
            try (URLClassLoader extClsLoader = Extension.extClassLoader(Paths.get(appHomePath.toString(), "ext").toFile());){
                Config configWithArgs;
                List<Extension> extensions = Extension.load(extClsLoader);
                Main.installExtensions(extensions, appHomePath);
                try {
                    Config fullDefaultConfig = Main.collectDefaults(extensions, defaultConfig, appHomePath);
                    configWithArgs = Main.applyArgsToConfig(args, fullDefaultConfig, initialStepId);
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedIfInterrupted(e);
                    LogUtil.exception(Level.ERROR, e, "Failed to load the defaults", new Object[0]);
                    throw e;
                }
                MetricsManagerImpl metricsMgr = new MetricsManagerImpl(ServiceTaskExecutor.INSTANCE);
                if (configWithArgs.boolVal("run-node")) {
                    Main.runNode(configWithArgs, extClsLoader, extensions, metricsMgr, appHomePath);
                } else {
                    Main.runScenario(configWithArgs, extensions, extClsLoader, metricsMgr, appHomePath);
                }
            }
        }
        catch (InterruptedException e) {
            Loggers.MSG.debug("Interrupted", (Throwable)e);
        }
        catch (Exception e) {
            LogUtil.trace(Loggers.ERR, Level.FATAL, e, "Unexpected failure", new Object[0]);
        }
    }

    private static Config loadDefaultConfig(Path appHomePath) throws Exception {
        Map mainConfigSchema = (Map)SchemaProvider.resolve("mongoose", Thread.currentThread().getContextClassLoader()).stream().findFirst().orElseThrow(IllegalStateException::new);
        return ConfigUtil.loadConfig(Paths.get(appHomePath.toString(), "config/defaults.yaml").toFile(), mainConfigSchema);
    }

    private static void installExtensions(List<Extension> extensions, Path appHomePath) {
        StringBuilder availExtMsg = new StringBuilder("Available/installed extensions:\n");
        extensions.forEach(ext -> {
            ext.install(appHomePath);
            String extId = ext.id();
            String extFqcn = ext.getClass().getCanonicalName();
            availExtMsg.append('\t').append(extId).append(' ').append(StringUtils.repeat("-", extId.length() < 30 ? 30 - extId.length() : 1)).append("> ").append(extFqcn).append('\n');
        });
        Loggers.MSG.info(availExtMsg);
    }

    private static Config collectDefaults(List<Extension> extensions, Config mainDefaults, Path appHomePath) throws Exception {
        List<Config> allDefaults = extensions.stream().map(ext -> ext.defaults(appHomePath)).filter(Objects::nonNull).collect(Collectors.toList());
        allDefaults.add(mainDefaults);
        return ConfigUtil.merge(mainDefaults.pathSep(), allDefaults);
    }

    private static Config applyArgsToConfig(String[] args, Config config, String initialStepId) {
        try {
            Main.argsWithAliases(args, config).forEach(config::val);
        }
        catch (IllegalArgumentNameException e) {
            String formattedAllCliArgs = CliArgUtil.allCliArgs(config.schema(), config.pathSep()).stream().collect(Collectors.joining("\n", "\t", ""));
            Loggers.ERR.fatal("Invalid argument: \"{}\"\nThe list of all possible args:\n{}", (Object)e.getMessage(), (Object)formattedAllCliArgs);
        }
        catch (InvalidValuePathException e) {
            Loggers.ERR.fatal("Invalid configuration option: \"{}\"", (Object)e.path());
        }
        catch (InvalidValueTypeException e) {
            Loggers.ERR.fatal("Invalid configuration value type for the option \"{}\", expected: {}, actual: {}", (Object)e.path(), (Object)e.expectedType(), (Object)e.actualType());
        }
        Main.checkAndSetStepId(config, initialStepId);
        Arrays.stream(args).forEach(Loggers.CLI::info);
        return config;
    }

    private static void checkAndSetStepId(Config config, String initialStepId) {
        if (null == config.val("load-step-id")) {
            config.val("load-step-id", initialStepId);
            config.val("load-step-idAutoGenerated", true);
        }
    }

    private static Map<String, String> argsWithAliases(String[] args, Config config) {
        Map<String, String> parsedArgs = CliArgUtil.parseArgs(args);
        List<Map<String, Object>> aliasingConfig = config.listVal("aliasing");
        return AliasingUtil.apply(parsedArgs, aliasingConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runNode(Config fullDefaultConfig, ClassLoader extClsLoader, List<Extension> extensions, MetricsManager metricsMgr, Path appHomePath) throws Exception {
        int port = fullDefaultConfig.intVal("run-port");
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler(context);
        RewriteHandler addCorsHeaderHandler = new RewriteHandler();
        addCorsHeaderHandler.addRule(new AddCorsHeadersRule());
        server.insertHandler(addCorsHeaderHandler);
        context.addServlet(new ServletHolder(new ConfigServlet(fullDefaultConfig)), "/config/*");
        context.addServlet(new ServletHolder(new LogServlet()), "/logs/*");
        context.addServlet(new ServletHolder(new MetricsServlet()), "/metrics");
        ServletHolder runServletHolder = new ServletHolder(new RunServlet(extClsLoader, extensions, metricsMgr, fullDefaultConfig, appHomePath));
        runServletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement("", 0x1000000L, 0x1000000L, 0x1000000));
        context.addServlet(runServletHolder, "/run/*");
        try {
            server.start();
            Loggers.MSG.info("Started to serve the remote API @ port # " + port);
            int listenPort = fullDefaultConfig.intVal("load-step-node-port");
            try (FileManagerServiceImpl fileMgrSvc = new FileManagerServiceImpl(listenPort);
                 LoadStepManagerServiceImpl scenarioStepSvc = new LoadStepManagerServiceImpl(listenPort, extensions, metricsMgr);){
                fileMgrSvc.start();
                scenarioStepSvc.start();
                scenarioStepSvc.await();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable cause) {
                LogUtil.trace(Loggers.ERR, Level.FATAL, cause, "Run node failure", new Object[0]);
            }
        }
        finally {
            server.stop();
        }
    }

    private static void runScenario(Config config, List<Extension> extensions, ClassLoader extClsLoader, MetricsManager metricsMgr, Path appHomePath) {
        Path scenarioPath = null;
        String scenarioFile = config.stringVal("run-scenario");
        if (scenarioFile != null && !scenarioFile.isEmpty()) {
            scenarioPath = Paths.get(scenarioFile, new String[0]);
        }
        Main.runScenarioFile(config, extensions, extClsLoader, metricsMgr, scenarioPath, appHomePath);
    }

    private static void runScenarioFile(Config config, List<Extension> extensions, ClassLoader extClsLoader, MetricsManager metricsMgr, Path scenarioPath, Path appHomePath) {
        String scenarioText;
        ScriptEngine scriptEngine;
        if (scenarioPath == null) {
            scriptEngine = ScenarioUtil.scriptEngineByDefault(extClsLoader);
            scenarioText = ScenarioUtil.defaultScenario(appHomePath);
        } else {
            scriptEngine = ScenarioUtil.scriptEngineByFilePath(scenarioPath, extClsLoader);
            StringBuilder strb = new StringBuilder();
            try {
                Files.lines(scenarioPath).forEach(line -> strb.append((String)line).append(System.lineSeparator()));
            }
            catch (IOException e) {
                LogUtil.exception(Level.FATAL, e, "Failed to read the scenario file \"{}\"", scenarioPath);
                try {
                    Files.list(scenarioPath.getParent()).forEach(System.out::println);
                }
                catch (IOException ee) {
                    LogUtil.trace(Loggers.ERR, Level.ERROR, ee, "Failed to list the scenarios parent directory", new Object[0]);
                }
            }
            scenarioText = strb.toString();
        }
        if (scriptEngine == null) {
            Loggers.ERR.fatal("Failed to resolve the scenario engine for the file \"{}\"", (Object)scenarioPath);
        } else {
            Loggers.MSG.info("Using the \"{}\" scenario engine", (Object)scriptEngine.getFactory().getEngineName());
            System.getenv().forEach(scriptEngine::put);
            ScenarioUtil.configure(scriptEngine, extensions, config, metricsMgr);
            new RunImpl("", scenarioText, scriptEngine, config.longVal("run-id")).run();
        }
    }
}

