/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.concurrent;

import com.emc.mongoose.base.concurrent.Daemon;
import com.github.akurilov.commons.concurrent.AsyncRunnableBase;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DaemonBase
extends AsyncRunnableBase
implements Daemon {
    private static final Logger LOG = Logger.getLogger(DaemonBase.class.getSimpleName());
    private static final Queue<WeakReference<Daemon>> REGISTRY = new ConcurrentLinkedQueue<WeakReference<Daemon>>();
    private final WeakReference<Daemon> daemonRef = new WeakReference<DaemonBase>(this);

    protected DaemonBase() {
        REGISTRY.add(this.daemonRef);
    }

    @Override
    public final void close() throws IOException {
        super.close();
        REGISTRY.remove(this.daemonRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        InterruptedException ex = null;
        Queue<WeakReference<Daemon>> queue = REGISTRY;
        synchronized (queue) {
            for (WeakReference weakReference : REGISTRY) {
                Daemon daemon = (Daemon)weakReference.get();
                try {
                    if (daemon == null || daemon.isClosed()) continue;
                    daemon.close();
                }
                catch (Throwable cause) {
                    if (cause instanceof InterruptedException) {
                        ex = (InterruptedException)cause;
                    }
                    LOG.log(Level.WARNING, "Failed to close the daemon instance", cause);
                }
            }
            REGISTRY.clear();
        }
        if (ex != null) {
            Exceptions.throwUnchecked(ex);
        }
    }
}

