/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.concurrent;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.concurrent.SingleTaskExecutor;
import com.emc.mongoose.base.logging.LogContextThreadFactory;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.apache.logging.log4j.Level;

public final class SingleTaskExecutorImpl
implements Runnable,
SingleTaskExecutor {
    private static final ThreadFactory THREAD_FACTORY = new LogContextThreadFactory("single_task_executor_", true);
    private final AtomicReference<Thread> workerRef = new AtomicReference<Object>(null);
    private final AtomicReference<Runnable> taskRef = new AtomicReference<Object>(null);

    public SingleTaskExecutorImpl() {
        this.startWorker();
    }

    private void startWorker() {
        if (this.workerRef.compareAndSet(null, THREAD_FACTORY.newThread(this))) {
            this.workerRef.get().start();
        }
    }

    private void stopWorker() {
        Thread worker = this.workerRef.getAndSet(null);
        if (null != worker) {
            worker.interrupt();
        }
    }

    @Override
    public final void run() {
        while (true) {
            Runnable task;
            if (null == (task = this.taskRef.get())) {
                LockSupport.parkNanos(1L);
                continue;
            }
            try {
                task.run();
                continue;
            }
            catch (Throwable cause) {
                Exceptions.throwUncheckedIfInterrupted(cause);
                LogUtil.trace(Loggers.ERR, Level.ERROR, cause, "Unexpected task execution failure", new Object[0]);
                continue;
            }
            finally {
                this.taskRef.set(null);
                continue;
            }
            break;
        }
    }

    @Override
    public final void execute(Runnable task) throws RejectedExecutionException {
        if (!this.taskRef.compareAndSet(null, task)) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public final Runnable task() {
        return this.taskRef.get();
    }

    @Override
    public final boolean stop(Runnable task) {
        if (this.taskRef.compareAndSet(task, null)) {
            this.stopWorker();
            this.startWorker();
            return true;
        }
        return false;
    }

    @Override
    public final void close() {
        this.stopWorker();
        this.taskRef.set(null);
    }
}

