/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.config;

import com.emc.mongoose.base.config.ConfigFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.akurilov.commons.collection.TreeUtil;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface ConfigUtil {
    public static ObjectMapper readConfigMapper(ConfigFormat format, Map<String, Object> schema) throws NoSuchMethodException {
        ObjectMapper mapper;
        switch (format) {
            case JSON: {
                mapper = new ObjectMapper();
                break;
            }
            case YAML: {
                mapper = new YAMLMapper();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return mapper.enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY).enable(SerializationFeature.INDENT_OUTPUT);
    }

    public static ObjectWriter writerWithPrettyPrinter(ObjectMapper om) {
        DefaultIndenter indenter = new DefaultIndenter("  ", DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith(indenter);
        printer.indentArraysWith(indenter);
        om.enable(SerializationFeature.INDENT_OUTPUT);
        return om.writer(printer);
    }

    public static ObjectWriter configWriter(ConfigFormat format) {
        ObjectMapper mapper;
        switch (format) {
            case JSON: {
                mapper = new ObjectMapper();
                break;
            }
            case YAML: {
                mapper = new YAMLMapper();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return ConfigUtil.writerWithPrettyPrinter(mapper);
    }

    public static Map<String, Object> configTree(Config config) {
        BasicConfig configCopy = new BasicConfig(config);
        Map<String, Object> configTree = configCopy.mapVal(null);
        for (Map.Entry e : configTree.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            if (!(val instanceof Config)) continue;
            configTree.replace(key, ConfigUtil.configTree((Config)val));
        }
        return configTree;
    }

    public static String toString(Config config, ConfigFormat format) {
        try {
            Map<String, Object> configTree = ConfigUtil.configTree(config);
            return ConfigUtil.configWriter(format).writeValueAsString(configTree);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Config loadConfig(File file, Map<String, Object> schema) throws NoSuchMethodException, IOException {
        ConfigFormat format = file.getName().endsWith(".json") ? ConfigFormat.JSON : ConfigFormat.YAML;
        Map configTree = (Map)ConfigUtil.readConfigMapper(format, schema).readValue(file, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return new BasicConfig("-", schema, configTree);
    }

    public static Config loadConfig(String content, ConfigFormat format, Map<String, Object> schema) throws NoSuchMethodException, IOException {
        Map configTree = (Map)ConfigUtil.readConfigMapper(format, schema).readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return new BasicConfig("-", schema, configTree);
    }

    public static Config merge(String pathSep, List<Config> configs) {
        Map schema = configs.stream().map(Config::schema).reduce(TreeUtil::addBranches).orElseGet(Collections::emptyMap);
        Map configTree = configs.stream().map(Config::deepToMap).reduce(TreeUtil::addBranches).orElseGet(Collections::emptyMap);
        return new BasicConfig(pathSep, schema, configTree);
    }

    public static void flatten(Map<String, Object> configMap, Map<String, String> argValPairs, String sep, String prefix) {
        for (String k : configMap.keySet()) {
            Object v = configMap.get(k);
            if (v instanceof Map) {
                ConfigUtil.flatten((Map)v, argValPairs, sep, (String)(prefix == null ? k : prefix + sep + k));
                continue;
            }
            if (v instanceof List) {
                String s = ((List)v).stream().map(e -> e == null ? ":" : e.toString()).collect(Collectors.joining(","));
                argValPairs.put((String)(prefix == null ? k : prefix + sep + k), s);
                continue;
            }
            argValPairs.put((String)(prefix == null ? k : prefix + sep + k), v == null ? null : v.toString());
        }
    }
}

