/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.config.el;

import com.github.akurilov.commons.math.Random;

public final class RandomPath {
    public static final char PATH_SEP = '/';
    public static final int RADIX = 36;
    private static final ThreadLocal<StringBuilder> THREAD_LOCAL_PATH_BUILDER = ThreadLocal.withInitial(StringBuilder::new);
    private static final ThreadLocal<Random> THREAD_LOCAL_RND = ThreadLocal.withInitial(Random::new);

    private RandomPath() {
    }

    public static String get(int width, int depth) {
        StringBuilder pathBuilder = THREAD_LOCAL_PATH_BUILDER.get();
        pathBuilder.setLength(0);
        Random rnd = THREAD_LOCAL_RND.get();
        int newDepth = rnd.nextInt(depth) + 1;
        for (int i = 0; i < newDepth; ++i) {
            String dirName = Integer.toUnsignedString(rnd.nextInt(width), 36);
            pathBuilder.append(dirName);
            pathBuilder.append('/');
        }
        return pathBuilder.toString();
    }
}

