/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.control;

import com.emc.mongoose.base.config.ConfigFormat;
import com.emc.mongoose.base.config.ConfigUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.io.yaml.TypeNames;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;

public class ConfigServlet
extends HttpServlet {
    private static final String SCHEMA_PATH = "schema";
    private static final String CONTEXT_SEP = "/";
    private final Config config;

    public ConfigServlet(Config config) {
        this.config = config;
    }

    @Override
    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] contexts = req.getRequestURI().split(CONTEXT_SEP);
        String acceptHeader = req.getHeader(HttpHeader.ACCEPT.toString());
        ConfigFormat configFormat = null == acceptHeader ? ConfigFormat.YAML : (acceptHeader.startsWith(MimeTypes.Type.APPLICATION_JSON.toString()) ? ConfigFormat.JSON : (acceptHeader.startsWith(MimeTypes.Type.TEXT_JSON.toString()) ? ConfigFormat.JSON : ConfigFormat.YAML));
        if (contexts.length == 2) {
            this.getConfig(resp, configFormat);
        } else if (contexts[2].equals(SCHEMA_PATH)) {
            this.getSchema(resp, configFormat);
        } else {
            resp.setStatus(400);
            resp.getWriter().print("<ERROR> Such URI not found : " + req.getRequestURI());
        }
    }

    private void getSchema(HttpServletResponse resp, ConfigFormat format) throws IOException {
        ObjectMapper mapper;
        switch (format) {
            case JSON: {
                mapper = new ObjectMapper();
                break;
            }
            case YAML: {
                mapper = new YAMLMapper();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        String schemaStr = ConfigUtil.writerWithPrettyPrinter(mapper).writeValueAsString(this.config.schema());
        for (String k : TypeNames.MAP.keySet()) {
            String v = TypeNames.MAP.get(k).getTypeName();
            schemaStr = schemaStr.replaceAll(v, k);
        }
        resp.setStatus(200);
        PrintWriter respWriter = resp.getWriter();
        respWriter.print(schemaStr);
    }

    private void getConfig(HttpServletResponse resp, ConfigFormat format) throws IOException {
        resp.setStatus(200);
        PrintWriter respWriter = resp.getWriter();
        respWriter.print(ConfigUtil.toString(this.config, format));
    }
}

