/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.control.logs;

import com.emc.mongoose.base.control.logs.InvalidUriPathException;
import com.emc.mongoose.base.control.logs.MultipleByteRangesException;
import com.emc.mongoose.base.control.logs.NoLogFileException;
import com.emc.mongoose.base.control.logs.NoLoggerException;
import com.emc.mongoose.base.logging.Loggers;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.InclusiveByteRange;

public final class LogServlet
extends HttpServlet {
    private static final String KEY_STEP_ID = "stepId";
    private static final String KEY_LOGGER_NAME = "loggerName";
    private static final Pattern PATTERN_URI_PATH = Pattern.compile("/logs/(?<stepId>[\\w\\-_.,;:~=+@]+)/(?<loggerName>[\\w_.]+)");
    private static final String PATTERN_STEP_ID_SUBST = "${ctx:step_id}";
    private static final int LOG_PAGE_SIZE_LIMIT = 0x100000;
    private final Map<String, String> logFileNamePatternByName = Arrays.stream(Loggers.class.getFields()).map(field -> {
        try {
            return field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }).filter(fieldVal -> fieldVal instanceof Logger).map(o -> (Logger)o).filter(logger -> logger.getName().startsWith(Loggers.BASE)).collect(Collectors.toMap(logger -> logger.getName().substring(Loggers.BASE.length()), logger -> ((AsyncLogger)logger).getAppenders().values().stream().filter(appender -> appender instanceof RollingRandomAccessFileAppender).map(appender -> ((RollingRandomAccessFileAppender)appender).getFilePattern()).findAny().orElse("")));

    @Override
    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.logFilePath(req).ifPresentOrElse(path -> {
                try {
                    try {
                        LogServlet.respondFileContent(path, req, resp);
                        resp.setStatus(200);
                    }
                    catch (MultipleByteRangesException e) {
                        resp.sendError(416, e.getMessage());
                    }
                }
                catch (Exception e) {
                    Exceptions.throwUnchecked(e);
                }
            }, () -> {
                try {
                    LogServlet.writeLogNamesJson(resp.getOutputStream());
                    resp.setStatus(200);
                }
                catch (IOException e) {
                    Exceptions.throwUnchecked(e);
                }
            });
        }
        catch (InvalidUriPathException | NoLoggerException e) {
            resp.sendError(400, e.getMessage());
        }
        catch (NoLogFileException e) {
            resp.sendError(404, e.getMessage());
        }
    }

    @Override
    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.logFilePath(req).ifPresentOrElse(path -> {
                try {
                    Files.delete(path);
                    resp.setStatus(200);
                }
                catch (IOException e) {
                    resp.setStatus(500, "Failed to delete the log file");
                }
            }, () -> {
                try {
                    resp.sendError(400);
                }
                catch (IOException e) {
                    Exceptions.throwUnchecked(e);
                }
            });
        }
        catch (InvalidUriPathException | NoLoggerException e) {
            resp.sendError(400, e.getMessage());
        }
        catch (NoLogFileException e) {
            resp.sendError(404, e.getMessage());
        }
    }

    private Optional<Path> logFilePath(HttpServletRequest req) throws NoLoggerException, NoLogFileException, InvalidUriPathException {
        String reqUri = req.getRequestURI();
        Matcher matcher = PATTERN_URI_PATH.matcher(reqUri);
        if (matcher.find()) {
            String stepId = matcher.group(KEY_STEP_ID);
            String loggerName = matcher.group(KEY_LOGGER_NAME);
            String logFileNamePattern = this.logFileNamePatternByName.get(loggerName);
            if (null == logFileNamePattern) {
                throw new NoLoggerException("No such logger: \"" + loggerName + "\"");
            }
            if (logFileNamePattern.isEmpty()) {
                throw new NoLogFileException("Unable to determine the log file for the logger \"" + loggerName + "\"");
            }
            String logFile = logFileNamePattern.replace(PATTERN_STEP_ID_SUBST, stepId);
            return Optional.of(Paths.get(logFile, new String[0]));
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void respondFileContent(Path filePath, HttpServletRequest req, HttpServletResponse resp) throws IOException, MultipleByteRangesException, NoLogFileException {
        long size;
        long offset;
        if (!Files.exists(filePath, new LinkOption[0])) throw new NoLogFileException("The log file doesn't exist");
        Enumeration<String> rangeHeaders = req.getHeaders(HttpHeader.RANGE.asString());
        List<InclusiveByteRange> byteRanges = InclusiveByteRange.satisfiableRanges(rangeHeaders, Files.size(filePath));
        if (byteRanges == null || 0 == byteRanges.size()) {
            offset = 0L;
            size = 1048575L;
        } else {
            if (1 != byteRanges.size()) throw new MultipleByteRangesException("Unable to process more than 1 range header");
            InclusiveByteRange byteRange = byteRanges.get(0);
            offset = byteRange.getFirst();
            size = byteRange.getLast() + 1L;
        }
        LogServlet.writeFileRange(filePath, offset, size, resp.getOutputStream(), resp.getBufferSize());
    }

    private static void writeFileRange(Path filePath, long offset, long size, OutputStream out, int buffSize) throws IOException {
        int sizeLimit = (int)Math.min(size, 0x100000L);
        try (InputStream in = Files.newInputStream(filePath, new OpenOption[0]);){
            int n;
            for (long skipped = 0L; offset > skipped; skipped += in.skip(offset - skipped)) {
            }
            byte[] buff = new byte[Math.min(sizeLimit, buffSize)];
            for (long done = 0L; done < (long)sizeLimit && -1 != (n = in.read(buff)); done += (long)n) {
                out.write(buff, 0, n);
            }
        }
    }

    private static void writeLogNamesJson(OutputStream out) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false).writerWithDefaultPrettyPrinter().writeValue(out, Loggers.DESCRIPTIONS_BY_NAME);
        out.write(System.lineSeparator().getBytes());
        out.flush();
    }
}

