/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.control.run;

import com.emc.mongoose.base.concurrent.SingleTaskExecutor;
import com.emc.mongoose.base.concurrent.SingleTaskExecutorImpl;
import com.emc.mongoose.base.config.ConfigFormat;
import com.emc.mongoose.base.config.ConfigUtil;
import com.emc.mongoose.base.control.run.Run;
import com.emc.mongoose.base.control.run.RunImpl;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.load.step.ScenarioUtil;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.fasterxml.jackson.core.JsonParseException;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.exceptions.InvalidValuePathException;
import com.github.akurilov.confuse.exceptions.InvalidValueTypeException;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.logging.log4j.Level;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;

public class RunServlet
extends HttpServlet {
    private static final String PART_KEY_DEFAULTS = "defaults";
    private static final String PART_KEY_SCENARIO = "scenario";
    private final ScriptEngine scriptEngine;
    private final List<Extension> extensions;
    private final MetricsManager metricsMgr;
    private final Config aggregatedConfigWithArgs;
    private final Path appHomePath;
    private final SingleTaskExecutor scenarioExecutor = new SingleTaskExecutorImpl();

    public RunServlet(ClassLoader clsLoader, List<Extension> extensions, MetricsManager metricsMgr, Config aggregatedConfigWithArgs, Path appHomePath) {
        this.scriptEngine = ScenarioUtil.scriptEngineByDefault(clsLoader);
        this.extensions = extensions;
        this.metricsMgr = metricsMgr;
        this.aggregatedConfigWithArgs = aggregatedConfigWithArgs;
        this.appHomePath = appHomePath;
    }

    @Override
    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        Part scenarioPart;
        Part defaultsPart;
        String contentTypeHeaderValue = req.getHeader(HttpHeader.CONTENT_TYPE.toString());
        if (contentTypeHeaderValue != null && contentTypeHeaderValue.startsWith(MimeTypes.Type.MULTIPART_FORM_DATA.toString())) {
            defaultsPart = req.getPart(PART_KEY_DEFAULTS);
            scenarioPart = req.getPart(PART_KEY_SCENARIO);
        } else {
            defaultsPart = null;
            scenarioPart = null;
        }
        try {
            Config config = RunServlet.mergeIncomingWithLocalConfig(defaultsPart, resp, this.aggregatedConfigWithArgs);
            String scenario = RunServlet.getIncomingScenarioOrDefault(scenarioPart, this.appHomePath);
            if (config.longVal("run-id") == 0L) {
                config.val("run-id", System.currentTimeMillis());
            }
            ScenarioUtil.configure(this.scriptEngine, this.extensions, config, this.metricsMgr);
            RunImpl run = new RunImpl(config.stringVal("run-comment"), scenario, this.scriptEngine, config.longVal("run-id"));
            try {
                this.scenarioExecutor.execute(run);
                resp.setStatus(202);
                RunServlet.setRunTimestampHeader(run, resp);
            }
            catch (RejectedExecutionException e) {
                resp.setStatus(409);
            }
        }
        catch (NoSuchMethodException | RuntimeException e) {
            LogUtil.exception(Level.WARN, e, "Failed to run a scenario with the request {}", req);
            resp.setStatus(400);
        }
    }

    @Override
    protected final void doHead(HttpServletRequest req, HttpServletResponse resp) {
        this.applyForActiveRunIfAny(resp, RunServlet::setRunExistsResponse);
    }

    @Override
    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.extractRequestTimestampAndApply(req, resp, (run, runId) -> RunServlet.setRunMatchesResponse(run, resp, runId));
    }

    @Override
    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.extractRequestTimestampAndApply(req, resp, (run, runId) -> RunServlet.stopRunIfMatchesAndSetResponse(run, resp, runId, this.scenarioExecutor));
    }

    static void setRunTimestampHeader(Run task, HttpServletResponse resp) {
        resp.setHeader(HttpHeader.ETAG.name(), String.valueOf(task.runId()));
    }

    void applyForActiveRunIfAny(HttpServletResponse resp, BiConsumer<Run, HttpServletResponse> action) {
        Runnable activeTask = this.scenarioExecutor.task();
        if (null == activeTask) {
            resp.setStatus(204);
        } else if (activeTask instanceof Run) {
            Run activeRun = (Run)activeTask;
            action.accept(activeRun, resp);
        } else {
            Loggers.ERR.warn("The scenario executor runs an alien task: {}", (Object)activeTask);
            resp.setStatus(204);
        }
    }

    void extractRequestTimestampAndApply(HttpServletRequest req, HttpServletResponse resp, BiConsumer<Run, Long> runRespRunIdConsumer) throws IOException {
        String rawIncomingRunId = Collections.list(req.getHeaders(HttpHeader.IF_MATCH.toString())).stream().findAny().orElse(null);
        long incomingRunId = Long.parseLong(rawIncomingRunId);
        if (rawIncomingRunId == null) {
            resp.sendError(400, "Missing header: " + HttpHeader.IF_MATCH);
        } else {
            try {
                this.applyForActiveRunIfAny(resp, (run, resp_) -> runRespRunIdConsumer.accept((Run)run, incomingRunId));
            }
            catch (NumberFormatException e) {
                resp.sendError(400, "Invalid start time: " + incomingRunId);
            }
        }
    }

    static void setRunExistsResponse(Run run, HttpServletResponse resp) {
        resp.setStatus(200);
        RunServlet.setRunTimestampHeader(run, resp);
    }

    static void setRunMatchesResponse(Run run, HttpServletResponse resp, long incomingRunId) {
        if (run.runId() == incomingRunId) {
            resp.setStatus(200);
        } else {
            resp.setStatus(204);
        }
    }

    static void stopRunIfMatchesAndSetResponse(Run run, HttpServletResponse resp, long runId, SingleTaskExecutor scenarioExecutor) {
        if (run.runId() == runId) {
            scenarioExecutor.stop(run);
            if (null != scenarioExecutor.task()) {
                throw new AssertionError((Object)"Run stopping failure");
            }
            resp.setStatus(200);
        } else {
            resp.setStatus(404);
        }
    }

    static Config mergeIncomingWithLocalConfig(Part defaultsPart, HttpServletResponse resp, Config aggregatedConfigWithArgs) throws IOException, NoSuchMethodException, InvalidValuePathException, InvalidValueTypeException {
        Config configResult;
        if (defaultsPart == null) {
            configResult = new BasicConfig(aggregatedConfigWithArgs);
        } else {
            Config configIncoming = RunServlet.configFromPart(defaultsPart, resp, aggregatedConfigWithArgs.schema());
            try {
                String loadStepIdIncoming = configIncoming.stringVal("load-step-id");
                if (null != loadStepIdIncoming && !loadStepIdIncoming.isEmpty()) {
                    configIncoming.val("load-step-idAutoGenerated", false);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            configResult = ConfigUtil.merge(aggregatedConfigWithArgs.pathSep(), Arrays.asList(aggregatedConfigWithArgs, configIncoming));
        }
        return configResult;
    }

    static Config configFromPart(Part defaultsPart, HttpServletResponse resp, Map<String, Object> configSchema) throws IOException, NoSuchMethodException, InvalidValuePathException, InvalidValueTypeException {
        String rawDefaultsData;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(defaultsPart.getInputStream()));){
            rawDefaultsData = br.lines().collect(Collectors.joining("\n"));
        }
        String contentType = defaultsPart.getContentType();
        ConfigFormat format = ConfigFormat.YAML;
        if (contentType != null) {
            if (contentType.startsWith(MimeTypes.Type.APPLICATION_JSON.toString())) {
                format = ConfigFormat.JSON;
            } else if (contentType.startsWith(MimeTypes.Type.TEXT_JSON.toString())) {
                format = ConfigFormat.JSON;
            }
        }
        try {
            return ConfigUtil.loadConfig(rawDefaultsData, format, configSchema);
        }
        catch (JsonParseException e) {
            if (ConfigFormat.YAML.equals((Object)format)) {
                return ConfigUtil.loadConfig(rawDefaultsData, ConfigFormat.JSON, configSchema);
            }
            throw e;
        }
    }

    static String getIncomingScenarioOrDefault(Part scenarioPart, Path appHomePath) throws IOException {
        String scenarioResult;
        if (scenarioPart == null) {
            scenarioResult = ScenarioUtil.defaultScenario(appHomePath);
        } else {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(scenarioPart.getInputStream()));){
                scenarioResult = br.lines().collect(Collectors.joining("\n"));
            }
        }
        return scenarioResult;
    }

    @Override
    public final void destroy() {
        this.scenarioExecutor.close();
        super.destroy();
    }
}

