/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.data;

import com.emc.mongoose.base.data.ExternalDataInput;
import com.emc.mongoose.base.data.SeedDataInput;
import com.github.akurilov.commons.math.MathUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public interface DataInput
extends Closeable {
    public int getSize();

    public MappedByteBuffer getLayer(int var1);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataInput instance(String inputFilePath, String seed, SizeInBytes layerSize, int layerCacheLimit) throws IOException, IllegalStateException, IllegalArgumentException {
        void var4_11;
        long layerSizeBytes = layerSize.get();
        if (layerSizeBytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Item data layer size should be less than 2GB");
        }
        if (inputFilePath != null && !inputFilePath.isEmpty()) {
            Path p = Paths.get(inputFilePath, new String[0]);
            if (!Files.exists(p, new LinkOption[0]) || Files.isDirectory(p, new LinkOption[0]) || !Files.isReadable(p)) throw new AssertionError((Object)("Item data input file @" + p.toAbsolutePath() + " doesn't exist/not readable/is a directory"));
            File f = p.toFile();
            long fileSize = f.length();
            if (fileSize <= 0L) throw new AssertionError((Object)("Item data input file @" + p.toAbsolutePath() + " is empty"));
            if (fileSize > Integer.MAX_VALUE) {
                throw new AssertionError((Object)"Item data input file size should be less than 2GB");
            }
            try (SeekableByteChannel rbc = Files.newByteChannel(p, StandardOpenOption.READ);){
                ExternalDataInput externalDataInput = new ExternalDataInput(rbc, (int)layerSizeBytes, layerCacheLimit);
                return var4_11;
            }
        } else {
            SeedDataInput seedDataInput = new SeedDataInput(Long.parseLong(seed, 16), (int)layerSizeBytes, layerCacheLimit);
        }
        return var4_11;
    }

    public static void generateData(MappedByteBuffer byteLayer, long seed) {
        int i;
        int ringBuffSize = byteLayer.capacity();
        int countWordBytes = 8;
        int countWords = ringBuffSize / 8;
        int countTailBytes = ringBuffSize % 8;
        long word = seed;
        byteLayer.clear();
        for (i = 0; i < countWords; ++i) {
            byteLayer.putLong(word);
            word = MathUtil.xorShift(word);
        }
        ByteBuffer tailBytes = ByteBuffer.allocate(8);
        tailBytes.asLongBuffer().put(word).rewind();
        for (i = 0; i < countTailBytes; ++i) {
            byteLayer.put(8 * countWords + i, tailBytes.get(i));
        }
    }

    public static enum Type {
        FILE,
        SEED;

    }
}

