/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.env;

import com.emc.mongoose.base.Constants;
import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.config.BundledDefaultsProvider;
import com.emc.mongoose.base.env.InstallableJarResources;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.SchemaProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public final class CoreResourcesToInstall
extends InstallableJarResources {
    public static final String RESOURCES_FILE_NAME = "/install_resources.txt";
    private final Path appHomePath;

    public CoreResourcesToInstall() {
        Config bundledDefaults;
        try {
            Map<String, Object> schema = SchemaProvider.resolveAndReduce("mongoose", Thread.currentThread().getContextClassLoader());
            bundledDefaults = new BundledDefaultsProvider().config("-", schema);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedIfInterrupted(e);
            throw new IllegalStateException("Failed to load the bundled default config from the resources", e);
        }
        String appVersion = bundledDefaults.stringVal("run-version");
        String msg = " mongoose v " + appVersion + " ";
        String pad = StringUtils.repeat("#", (120 - msg.length()) / 2);
        System.out.println(pad + msg + pad);
        this.appHomePath = Paths.get(Constants.USER_HOME, ".mongoose", appVersion);
    }

    public final Path appHomePath() {
        return this.appHomePath;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final List<String> resourceFilesToInstall() {
        try (InputStream in = this.getClass().getResourceAsStream(RESOURCES_FILE_NAME);){
            List<String> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                list = reader.lines().collect(Collectors.toList());
            }
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load the resources list");
        }
    }
}

