/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.env;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.config.ConfigUtil;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.env.InstallableJarResources;
import com.emc.mongoose.base.logging.LogUtil;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.SchemaProvider;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.logging.log4j.Level;

public abstract class ExtensionBase
extends InstallableJarResources
implements Extension {
    @Override
    public final Config defaults(Path appHomePath) {
        Map<String, Object> schema;
        SchemaProvider schemaProvider = this.schemaProvider();
        if (schemaProvider == null) {
            schema = null;
        } else {
            try {
                schema = schemaProvider.schema();
            }
            catch (Exception e) {
                LogUtil.exception(Level.WARN, e, "{}: failed to load the schema", schemaProvider);
                return null;
            }
        }
        String defaultsFileName = this.defaultsFileName();
        if (defaultsFileName == null) {
            return null;
        }
        File defaultsFile = Paths.get(appHomePath.toString(), "config", defaultsFileName).toFile();
        try {
            return ConfigUtil.loadConfig(defaultsFile, schema);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedIfInterrupted(e);
            LogUtil.exception(Level.WARN, e, "Failed to load the defaults config from \"{}\"", defaultsFile);
            return null;
        }
    }

    protected abstract String defaultsFileName();
}

