/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item;

import com.emc.mongoose.base.data.DataCorruptionException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.io.AsyncChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.BitSet;

public interface DataItem
extends Item,
SeekableByteChannel {
    public static final double LOG2 = Math.log(2.0);

    public DataInput dataInput();

    public void dataInput(DataInput var1);

    @Override
    public void reset();

    public int layer();

    public void layer(int var1);

    public void size(long var1);

    public long offset();

    public void offset(long var1);

    @Override
    public long position();

    @Override
    public DataItem position(long var1);

    public <D extends DataItem> D slice(long var1, long var3);

    public long writeToSocketChannel(WritableByteChannel var1, long var2) throws IOException;

    public long writeToFileChannel(FileChannel var1, long var2) throws IOException;

    public <A> void writeToAsyncChannel(AsyncChannel var1, long var2, long var4, A var6, CompletionHandler<Integer, ? super A> var7);

    public void verify(ByteBuffer var1) throws DataCorruptionException;

    public static int rangeCount(long size) {
        return (int)Math.ceil(Math.log(size + 1L) / LOG2);
    }

    public static long rangeOffset(int i) {
        return (1 << i) - 1;
    }

    public long rangeSize(int var1);

    public boolean isUpdated();

    public boolean isRangeUpdated(int var1);

    public int updatedRangesCount();

    public void commitUpdatedRanges(BitSet[] var1);
}

